/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.RepositoryContext;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceCopier;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryCopier {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryCopier.class);
    private final RepositoryContext source;
    private final RepositoryContext target;

    public static void copy(File source, File target) throws RepositoryException, IOException {
        RepositoryCopier.copy(RepositoryConfig.create((File)source), RepositoryConfig.install((File)target));
    }

    public static void copy(RepositoryConfig source, File target) throws RepositoryException, IOException {
        RepositoryCopier.copy(source, RepositoryConfig.install((File)target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RepositoryConfig source, RepositoryConfig target) throws RepositoryException {
        RepositoryImpl repository = RepositoryImpl.create(source);
        try {
            RepositoryCopier.copy(repository, target);
        }
        finally {
            repository.shutdown();
        }
    }

    public static void copy(RepositoryImpl source, File target) throws RepositoryException, IOException {
        RepositoryCopier.copy(source, RepositoryConfig.install((File)target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RepositoryImpl source, RepositoryConfig target) throws RepositoryException {
        RepositoryImpl repository = RepositoryImpl.create(target);
        try {
            new RepositoryCopier(source, repository).copy();
        }
        finally {
            repository.shutdown();
        }
        File targetDir = new File(target.getHomeDir());
        File repoDir = new File(targetDir, "repository");
        FileUtils.deleteQuietly((File)new File(repoDir, "index"));
        File[] workspaces = new File(targetDir, "workspaces").listFiles();
        if (workspaces != null) {
            for (File workspace : workspaces) {
                FileUtils.deleteQuietly((File)new File(workspace, "index"));
            }
        }
    }

    public RepositoryCopier(RepositoryImpl source, RepositoryImpl target) {
        this.source = source.getRepositoryContext();
        this.target = target.getRepositoryContext();
    }

    public void copy() throws RepositoryException {
        logger.info("Copying repository content from {} to {}", (Object)this.source.getRepository().repConfig.getHomeDir(), (Object)this.target.getRepository().repConfig.getHomeDir());
        try {
            this.copyNamespaces();
            this.copyNodeTypes();
            this.copyVersionStore();
            this.copyWorkspaces();
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to copy content", (Throwable)e);
        }
    }

    private void copyNamespaces() throws RepositoryException {
        NamespaceRegistryImpl sourceRegistry = this.source.getNamespaceRegistry();
        NamespaceRegistryImpl targetRegistry = this.target.getNamespaceRegistry();
        logger.info("Copying registered namespaces");
        List<String> existing = Arrays.asList(targetRegistry.getURIs());
        for (String uri : sourceRegistry.getURIs()) {
            if (existing.contains(uri)) continue;
            targetRegistry.registerNamespace(sourceRegistry.getPrefix(uri), uri);
        }
    }

    private void copyNodeTypes() throws RepositoryException {
        NodeTypeRegistry sourceRegistry = this.source.getNodeTypeRegistry();
        NodeTypeRegistry targetRegistry = this.target.getNodeTypeRegistry();
        logger.info("Copying registered node types");
        List<Name> existing = Arrays.asList(targetRegistry.getRegisteredNodeTypes());
        ArrayList<QNodeTypeDefinition> register = new ArrayList<QNodeTypeDefinition>();
        for (Name name : sourceRegistry.getRegisteredNodeTypes()) {
            if (existing.contains(name)) continue;
            register.add(sourceRegistry.getNodeTypeDef(name));
        }
        try {
            targetRegistry.registerNodeTypes(register);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Unable to copy node types", (Throwable)e);
        }
    }

    private void copyVersionStore() throws RepositoryException {
        logger.info("Copying version histories");
        PersistenceCopier copier = new PersistenceCopier(this.source.getInternalVersionManager().getPersistenceManager(), this.target.getInternalVersionManager().getPersistenceManager(), this.target.getDataStore());
        copier.copy(RepositoryImpl.VERSION_STORAGE_NODE_ID);
        copier.copy(RepositoryImpl.ACTIVITIES_NODE_ID);
    }

    private void copyWorkspaces() throws RepositoryException {
        List<String> existing = Arrays.asList(this.target.getRepository().getWorkspaceNames());
        for (String name : this.source.getRepository().getWorkspaceNames()) {
            logger.info("Copying workspace {}", (Object)name);
            if (!existing.contains(name)) {
                this.target.getRepository().createWorkspace(name);
            }
            PersistenceCopier copier = new PersistenceCopier(this.source.getRepository().getWorkspaceInfo(name).getPersistenceManager(), this.target.getRepository().getWorkspaceInfo(name).getPersistenceManager(), this.target.getDataStore());
            copier.excludeNode(RepositoryImpl.SYSTEM_ROOT_NODE_ID);
            copier.copy(RepositoryImpl.ROOT_NODE_ID);
            LockManagerImpl sourceLockManager = this.source.getRepository().getLockManager(name);
            LockManagerImpl targetLockManager = this.target.getRepository().getLockManager(name);
            targetLockManager.copyOpenScopedLocksFrom(sourceLockManager);
        }
    }
}

