/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemRemoveOperation;
import org.apache.jackrabbit.core.ItemValidator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.retention.RetentionManagerImpl;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.session.SessionOperation;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;

public abstract class ProtectedItemModifier {
    private static final int DEFAULT_PERM_CHECK = -1;
    private final int permission;

    protected ProtectedItemModifier() {
        this(-1);
    }

    protected ProtectedItemModifier(int permission) {
        Class<?> cl = this.getClass();
        if (!(UserManagerImpl.class.isAssignableFrom(cl) || RetentionManagerImpl.class.isAssignableFrom(cl) || ACLEditor.class.isAssignableFrom(cl) || org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor.class.isAssignableFrom(cl))) {
            throw new IllegalArgumentException("Only UserManagerImpl, RetentionManagerImpl and ACLEditor may extend from the ProtectedItemModifier");
        }
        this.permission = permission;
    }

    protected NodeImpl addNode(NodeImpl parentImpl, Name name, Name ntName) throws RepositoryException {
        return this.addNode(parentImpl, name, ntName, null);
    }

    protected NodeImpl addNode(NodeImpl parentImpl, Name name, Name ntName, NodeId nodeId) throws RepositoryException {
        this.checkPermission(parentImpl, name, this.getPermission(true, false));
        parentImpl.checkSetProperty();
        NodeTypeImpl nodeType = parentImpl.sessionContext.getNodeTypeManager().getNodeType(ntName);
        NodeDefinitionImpl def = parentImpl.getApplicableChildNodeDefinition(name, ntName);
        NodeState thisState = parentImpl.getNodeState();
        ChildNodeEntry cne = thisState.getChildNodeEntry(name, 1);
        if (cne != null) {
            if (!def.allowsSameNameSiblings()) {
                throw new ItemExistsException();
            }
            NodeId newId = cne.getId();
            NodeImpl n = (NodeImpl)parentImpl.sessionContext.getItemManager().getItem((ItemId)newId);
            if (!n.getDefinition().allowsSameNameSiblings()) {
                throw new ItemExistsException();
            }
        }
        return parentImpl.createChildNode(name, nodeType, nodeId);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value value) throws RepositoryException {
        return this.setProperty(parentImpl, name, value, false);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value value, boolean ignorePermissions) throws RepositoryException {
        if (!ignorePermissions) {
            this.checkPermission(parentImpl, name, this.getPermission(false, false));
        }
        parentImpl.checkSetProperty();
        InternalValue intVs = InternalValue.create((Value)value, (NamePathResolver)parentImpl.sessionContext);
        return parentImpl.internalSetProperty(name, intVs);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value[] values) throws RepositoryException {
        this.checkPermission(parentImpl, name, this.getPermission(false, false));
        parentImpl.checkSetProperty();
        InternalValue[] intVs = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            intVs[i] = InternalValue.create((Value)values[i], (NamePathResolver)parentImpl.sessionContext);
        }
        return parentImpl.internalSetProperty(name, intVs);
    }

    protected Property setProperty(NodeImpl parentImpl, Name name, Value[] values, int type) throws RepositoryException {
        this.checkPermission(parentImpl, name, this.getPermission(false, false));
        parentImpl.checkSetProperty();
        InternalValue[] intVs = new InternalValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            intVs[i] = InternalValue.create((Value)values[i], (NamePathResolver)parentImpl.sessionContext);
        }
        return parentImpl.internalSetProperty(name, intVs, type);
    }

    protected void removeItem(ItemImpl itemImpl) throws RepositoryException {
        NodeImpl n = itemImpl.isNode() ? (NodeImpl)itemImpl : (NodeImpl)itemImpl.getParent();
        this.checkPermission(itemImpl, this.getPermission(itemImpl.isNode(), true));
        n.checkSetProperty();
        itemImpl.perform(new ItemRemoveOperation(itemImpl, false));
    }

    protected void markModified(NodeImpl parentImpl) throws RepositoryException {
        parentImpl.getOrCreateTransientItemState();
    }

    protected <T> T performProtected(SessionImpl session, SessionOperation<T> operation) throws RepositoryException {
        ItemValidator itemValidator = session.context.getItemValidator();
        return itemValidator.performRelaxed(operation, 16);
    }

    private void checkPermission(ItemImpl item, int perm) throws RepositoryException {
        if (perm > 0) {
            SessionImpl sImpl = (SessionImpl)item.getSession();
            AccessManager acMgr = sImpl.getAccessManager();
            Path path = item.getPrimaryPath();
            acMgr.checkPermission(path, perm);
        }
    }

    private void checkPermission(NodeImpl node, Name childName, int perm) throws RepositoryException {
        SessionImpl sImpl;
        AccessManager acMgr;
        boolean isGranted;
        if (perm > 0 && !(isGranted = (acMgr = (sImpl = (SessionImpl)node.getSession()).getAccessManager()).isGranted(node.getPrimaryPath(), childName, perm))) {
            throw new AccessDeniedException("Permission denied.");
        }
    }

    private int getPermission(boolean isNode, boolean isRemove) {
        if (this.permission < 0) {
            if (isNode) {
                return isRemove ? 8 : 4;
            }
            return isRemove ? 16 : 2;
        }
        return this.permission;
    }
}

