/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl.virtual;

import com.day.crx.CRXSession;
import com.day.crx.mount.virtual.CompositeWorkspaceAddressResolver;
import com.day.crx.mount.virtual.JCRConfiguration;
import com.day.crx.mount.virtual.VirtualRepository;
import com.day.crx.mount.virtual.VirtualRepositoryConfiguration;
import com.day.crx.mount.virtual.WorkspaceAddressResolver;
import com.day.crx.sling.server.impl.virtual.OsgiWorkspaceAddressResolver;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualRepositoryWrapper {
    private static final Logger log = LoggerFactory.getLogger(VirtualRepositoryWrapper.class);
    private VirtualRepository repo;
    private String configWspName = "crx.default";
    private String configPath = "/etc/virtual-repositories/virtual-crx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrap(CRXSession s, BundleContext bundleContext) throws RepositoryException {
        CRXSession session = s.getSession(this.configWspName);
        try {
            Item item;
            if (session.itemExists(this.configPath) && (item = session.getItem(this.configPath)).isNode()) {
                Node n = (Node)item;
                CompositeWorkspaceAddressResolver addressResolver = new CompositeWorkspaceAddressResolver();
                addressResolver.register((WorkspaceAddressResolver)new OsgiWorkspaceAddressResolver(bundleContext));
                JCRConfiguration config = new JCRConfiguration((Session)s.getSession(this.configWspName), n.getPath(), (WorkspaceAddressResolver)addressResolver);
                this.repo = new VirtualRepository((VirtualRepositoryConfiguration)config);
            }
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    public void destroy() {
        if (this.repo != null) {
            this.repo.dispose();
            this.repo = null;
        }
    }

    public VirtualRepository getRepository() {
        return this.repo;
    }

    public String getConfigWspName() {
        return this.configWspName;
    }

    public void setConfigWspName(String configWspName) {
        this.configWspName = configWspName;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }
}

