/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl;

import com.day.text.Text;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryCheckPlugin
extends AbstractWebConsolePlugin {
    private static final Logger log = LoggerFactory.getLogger(RepositoryCheckPlugin.class);
    private static final String LABEL = "repositorycheck";
    private static final String TITLE = "Repository Check";
    private static final String RESOURCE_PREFIX = "/repositorycheck/";
    private SlingRepository repository;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Form form = new Form(req);
        PrintWriter pw = res.getWriter();
        Session session = null;
        try {
            pw.println("<form method='POST'>");
            pw.println("<div><label>Workspace <select name='workspace' required='true'>");
            session = this.repository.loginAdministrative(form.workspace);
            for (String w : session.getWorkspace().getAccessibleWorkspaceNames()) {
                if (w.equals(form.workspace)) {
                    pw.println("<option selected='true'>" + w + "</option>");
                    continue;
                }
                pw.println("<option>" + w + "</option>");
            }
            pw.println("</select></label></div>");
            pw.println("<div><label>Check nodes below <input name='path' value='" + Text.escapeXml((String)form.path) + "' required='true' /></label></div>");
            pw.println("<hr />");
            pw.println("<div><label><input name='traversal' type='checkbox'" + (form.traversal ? " checked='true'" : "") + " /> Traversal check</label></div>");
            pw.println("<div><label><input name='fixinconsistencies' type='checkbox'" + (form.fixInconsistencies ? " checked='true'" : "") + " /> Fix inconsistencies</label></div>");
            pw.println("<div><label><input name='log' type='checkbox'" + (form.log ? " checked='true'" : "") + " /> Log each node</label></div>");
            pw.println("<hr />");
            pw.println("<div><label><input name='datastoreconsistency' type='checkbox'" + (form.dsConsistency ? " checked='true'" : "") + " /> Data store consistency check</label></div>");
            pw.println("<div><input type='submit' value='Run' /></div>");
            pw.println("</form>");
            if ("POST".equals(req.getMethod())) {
                this.start(req, res, session, form);
            }
        }
        catch (RepositoryException e) {
            log.error("Error occur getting available workspaces", (Throwable)e);
            res.sendError(500, e.getMessage());
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(HttpServletRequest req, HttpServletResponse res, Session oSession, Form form) throws IOException {
        PrintWriter pw = res.getWriter();
        pw.println("<div class='results'>");
        try {
            SimpleCredentials sc = new SimpleCredentials(oSession.getUserID(), "".toCharArray());
            if (form.fixInconsistencies) {
                sc.setAttribute("org.apache.jackrabbit.autoFixCorruptions", (Object)"true");
            }
            Session session = oSession.impersonate((Credentials)sc);
            Node rootNode = null;
            try {
                rootNode = session.getNode(form.path);
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            try {
                Stats s;
                if (form.traversal && rootNode != null) {
                    pw.println("<p>Performing traversal check...</p>");
                    if (form.fixInconsistencies) {
                        pw.println("<p>Automatically fixing inconsistencies (see log file for details)...</p>");
                    }
                    s = new Stats();
                    s.calcSize = true;
                    long t1 = System.currentTimeMillis();
                    RepositoryCheckPlugin.traverse(pw, rootNode, s, form.log);
                    long t = System.currentTimeMillis() - t1;
                    pw.println(MessageFormat.format("<p>Traversed {0} nodes, {1} properties in {2} ms</p>", String.valueOf(s.numNodes), String.valueOf(s.numProps), String.valueOf(t)));
                    pw.println("<p>" + s.sizeProps + " bytes</p>");
                }
                if (form.dsConsistency && rootNode != null) {
                    pw.println("Performing data store consistency check...");
                    s = new Stats();
                    RepositoryCheckPlugin.dataStoreConsistency(pw, rootNode, s);
                    pw.println(MessageFormat.format("<p>Traversed {0} nodes, {1} errors found</p>", String.valueOf(s.numNodes), String.valueOf(s.numErrors)));
                }
                pw.println("<p>Done</p>");
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            pw.println("<p>Error occur: " + e.toString() + "</p>");
        }
        pw.println("</div>");
    }

    private static void traverse(PrintWriter out, Node n, Stats s, boolean logEachNode) throws IOException {
        s.numNodes++;
        try {
            long now = System.currentTimeMillis();
            if (logEachNode || s.nextLog == 0L || now > s.nextLog) {
                out.println("<p>" + n.getPath() + "</p>");
                out.flush();
                s.nextLog = 5000L + now;
            }
            PropertyIterator piter = n.getProperties();
            while (piter.hasNext()) {
                Property p = piter.nextProperty();
                s.numProps++;
                if (!s.calcSize) continue;
                if (p.isMultiple()) {
                    for (long l : p.getLengths()) {
                        s.sizeProps += l;
                    }
                    continue;
                }
                s.sizeProps += p.getLength();
            }
            NodeIterator iter = n.getNodes();
            while (iter.hasNext()) {
                RepositoryCheckPlugin.traverse(out, iter.nextNode(), s, logEachNode);
            }
        }
        catch (RepositoryException e) {
            try {
                out.println("<p>Error while traversing " + n.getPath() + ": " + e.toString() + "</p>");
            }
            catch (RepositoryException e1) {
                out.println("<p>Error while traversing " + n + ": " + e.toString() + "</p>");
            }
        }
    }

    private static void dataStoreConsistency(PrintWriter out, Node n, Stats s) throws IOException {
        s.numNodes++;
        try {
            PropertyIterator piter = n.getProperties();
            while (piter.hasNext()) {
                Property p = piter.nextProperty();
                try {
                    if (p.getType() == 2) {
                        if (p.getDefinition().isMultiple()) {
                            Value[] values = p.getValues();
                            for (int i = 0; i < values.length; ++i) {
                                values[i].getBinary().getStream().close();
                            }
                        } else {
                            p.getBinary().getStream().close();
                        }
                    }
                }
                catch (Exception e) {
                    String es = e.toString();
                    int idx = es.indexOf("datastore");
                    if (idx >= 0) {
                        if ((idx = (es = es.substring(idx + "datastore".length())).indexOf(58)) >= 0) {
                            es = es.substring(0, idx);
                        }
                        out.println("<p>missing file: " + es + "</p>");
                    } else {
                        out.println("<p>error: " + e.toString() + "</p>");
                    }
                    out.println("<p>in property: " + p.toString() + "</p>");
                    s.numErrors++;
                    out.flush();
                }
                s.numProps++;
            }
            NodeIterator iter = n.getNodes();
            while (iter.hasNext()) {
                RepositoryCheckPlugin.dataStoreConsistency(out, iter.nextNode(), s);
            }
        }
        catch (RepositoryException e) {
            try {
                out.println("<p>Error while traversing " + n.getPath() + ": " + e.toString() + "</p>");
            }
            catch (RepositoryException e1) {
                out.println("<p>Error while traversing " + n + ": " + e.toString() + "</p>");
            }
        }
    }

    protected String[] getCssReferences() {
        return new String[]{"/repositorycheck/res/repositorycheck.css"};
    }

    private URL getResource(String path) {
        return path != null && path.startsWith(RESOURCE_PREFIX) ? ((Object)((Object)this)).getClass().getResource(path.substring(RESOURCE_PREFIX.length() - 1)) : null;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    private static class Stats {
        private long numNodes;
        private long numProps;
        private long numErrors;
        private long sizeProps;
        private long nextLog;
        private boolean calcSize;

        private Stats() {
        }
    }

    private class Form {
        String workspace;
        boolean traversal;
        boolean fixInconsistencies;
        boolean log;
        boolean dsConsistency;
        String path;

        public Form(HttpServletRequest req) {
            this.workspace = req.getParameter("workspace");
            if (this.workspace == null || this.workspace.length() == 0) {
                this.workspace = RepositoryCheckPlugin.this.repository.getDefaultWorkspace();
            }
            this.traversal = "on".equals(req.getParameter("traversal"));
            this.fixInconsistencies = "on".equals(req.getParameter("fixinconsistencies"));
            this.log = "on".equals(req.getParameter("log"));
            this.dsConsistency = "on".equals(req.getParameter("datastoreconsistency"));
            this.path = req.getParameter("path");
            if (this.path == null || this.path.length() == 0) {
                this.path = "/";
            }
        }
    }
}

