/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profiler
implements Runnable {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final int MAX_ELEMENTS = 1000;
    public int interval = 50;
    public int depth = 16;
    public boolean paused;
    String[] ignoreLines = Profiler.arraySplit("", ',', true);
    String[] ignorePackages = Profiler.arraySplit("java.", ',', true);
    String[] ignoreThreads = Profiler.arraySplit("java.lang.Thread.dumpThreads,java.lang.Thread.getThreads,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead0,java.net.SocketOutputStream.socketWrite0,java.lang.UNIXProcess.waitForProcessExit,java.lang.Object.wait,java.lang.Thread.sleep,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run", ',', true);
    volatile boolean stop;
    private HashMap<String, Integer> counts = new HashMap();
    private HashMap<String, Integer> packages = new HashMap();
    private int minCount = 1;
    int total;
    private Thread thread;
    private long time;

    public void startCollecting() {
        this.thread = new Thread(this);
        this.thread.setName("Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
    }

    @Override
    public void run() {
        this.time = System.currentTimeMillis();
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable t) {
                // empty catch block
                break;
            }
        }
        this.time = System.currentTimeMillis() - this.time;
    }

    private void tick() {
        if (this.interval > 0) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] dump;
            Thread t = entry.getKey();
            if (t.getState() != Thread.State.RUNNABLE || (dump = entry.getValue()) == null || dump.length == 0 || Profiler.startsWithAny(dump[0].toString(), this.ignoreThreads)) continue;
            StringBuilder buff = new StringBuilder();
            String last = null;
            boolean packageCounts = false;
            int j = 0;
            for (int i = 0; i < dump.length && j < this.depth; ++i) {
                String el = dump[i].toString();
                if (el.equals(last) || Profiler.startsWithAny(el, this.ignoreLines)) continue;
                last = el;
                buff.append("at ").append(el);
                if (!packageCounts && !Profiler.startsWithAny(el, this.ignorePackages)) {
                    char c;
                    int index;
                    packageCounts = true;
                    for (index = 0; index < el.length() && !Character.isUpperCase(c = el.charAt(index)) && c != '('; ++index) {
                    }
                    if (index > 0 && el.charAt(index - 1) == '.') {
                        --index;
                    }
                    String packageName = el.substring(0, index);
                    Profiler.increment(this.packages, packageName, 0);
                    while ((index = packageName.lastIndexOf(46)) >= 0) {
                        packageName = packageName.substring(0, index);
                        Profiler.increment(this.packages, packageName + ".*", 0);
                    }
                    buff.append('+');
                }
                buff.append(LINE_SEPARATOR);
                ++j;
            }
            if (buff.length() <= 0) continue;
            this.minCount = Profiler.increment(this.counts, buff.toString().trim(), this.minCount);
            ++this.total;
        }
    }

    private static boolean startsWithAny(String s, String[] prefixes) {
        for (String p : prefixes) {
            if (p.length() <= 0 || !s.startsWith(p)) continue;
            return true;
        }
        return false;
    }

    private static int increment(HashMap<String, Integer> map, String trace, int minCount) {
        Integer oldCount = map.get(trace);
        if (oldCount == null) {
            map.put(trace, 1);
        } else {
            map.put(trace, oldCount + 1);
        }
        while (map.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> ei = map.entrySet().iterator();
            while (ei.hasNext()) {
                Map.Entry<String, Integer> e = ei.next();
                if (e.getValue() > minCount) continue;
                ei.remove();
            }
            if (map.size() <= 1000) continue;
            ++minCount;
        }
        return minCount;
    }

    public String getTop(int count) {
        this.stopCollecting();
        StringBuilder buff = new StringBuilder();
        buff.append("Profiler Results").append(LINE_SEPARATOR).append(LINE_SEPARATOR).append("Packages:").append(LINE_SEPARATOR);
        for (String k : new TreeSet<String>(this.packages.keySet())) {
            int percent = 100 * this.packages.get(k) / Math.max(this.total, 1);
            if (percent < 5) continue;
            if (percent < 10) {
                buff.append('0');
            }
            buff.append(percent).append("%: ").append(k).append(LINE_SEPARATOR);
        }
        buff.append(LINE_SEPARATOR).append("Top ").append(count).append(" stack trace(s) of ").append(this.time).append(" ms ").append(LINE_SEPARATOR);
        if (this.counts.size() == 0) {
            buff.append("(none)");
        }
        Profiler.appendTop(buff, this.counts, count, this.total);
        buff.append('.');
        return buff.toString();
    }

    private static void appendTop(StringBuilder buff, HashMap<String, Integer> map, int count, int total) {
        int x = 0;
        int min = 0;
        while (true) {
            int highest = 0;
            Map.Entry<String, Integer> best = null;
            for (Map.Entry<String, Integer> el : map.entrySet()) {
                if (el.getValue() <= highest && (el.getValue() != highest || el.getKey().length() >= best.getKey().length())) continue;
                best = el;
                highest = el.getValue();
            }
            if (best == null) break;
            map.remove(best.getKey());
            if (++x >= count) {
                if (best.getValue() < min) break;
                min = best.getValue();
            }
            int c = best.getValue();
            int percent = 100 * c / Math.max(total, 1);
            buff.append(c).append('/').append(total).append(" (").append(percent).append("%):").append(LINE_SEPARATOR).append(best.getKey()).append(LINE_SEPARATOR);
        }
    }

    public static String[] arraySplit(String s, char separatorChar, boolean trim) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buff = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separatorChar) {
                String e = buff.toString();
                list.add(trim ? e.trim() : e);
                buff.setLength(0);
                continue;
            }
            if (c == '\\' && i < s.length() - 1) {
                buff.append(s.charAt(++i));
                continue;
            }
            buff.append(c);
        }
        String e = buff.toString();
        list.add(trim ? e.trim() : e);
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }
}

