/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;

public class DiskBenchmarkPlugin
extends AbstractWebConsolePlugin {
    private static final String LABEL = "diskbenchmark";
    private static final String TITLE = "Disk Benchmark";
    private static final String RESOURCE_PREFIX = "/diskbenchmark/";
    private static volatile boolean stop;
    private ArrayList<String> results = new ArrayList();

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PrintWriter pw = res.getWriter();
        pw.println("<p class=\"intro\">This is a simple disk performance benchmark. It test how fast Java can read from and write to the hard disk. The test uses temporary files, which are deleted at the end of the run.</p>");
        String action = req.getParameter("action");
        if ("start".equals(action) && "POST".equals(req.getMethod())) {
            this.start(req, res);
        } else if (action == null || "stop".equals(action)) {
            this.stop(req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String directory = req.getParameter("directory");
        directory = new File(directory).getAbsolutePath();
        int fileSize = Integer.parseInt(req.getParameter("fileSize"));
        int time = Integer.parseInt(req.getParameter("time"));
        int delay = Integer.parseInt(req.getParameter("delay"));
        String mode = req.getParameter("mode");
        new File(directory).mkdirs();
        File temp = File.createTempFile("disktest-", null, new File(directory));
        temp.deleteOnExit();
        boolean sync = false;
        if (mode.endsWith("+")) {
            sync = true;
            mode = mode.substring(0, mode.length() - 1);
        }
        PrintWriter pw = res.getWriter();
        pw.println("<form method='post'>");
        pw.println("<input type='hidden' name='action' value='stop' />");
        pw.println("<input type='submit' value='Stop' />");
        pw.println("</form>");
        pw.println("<div class='info'>Directory: " + directory);
        pw.println("<br />File: " + temp.getAbsolutePath());
        pw.println("<br />File size (MB): " + fileSize);
        pw.println("<br />Run (ms): " + time);
        pw.println("<br />Delay (ms): " + delay);
        pw.println("<br />File mode: " + mode);
        pw.println("<br />Sync: " + sync);
        pw.println("<br />Collecting...</div>");
        pw.println("Data format: operation type, operations per second for block sizes 256 bytes, 512 bytes, 1 KB, 2 KB, 4 KB, 8 KB, 16 KB.<br />");
        pw.flush();
        stop = false;
        this.results.clear();
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(temp, "rw");
            f.setLength(fileSize * 1024 * 1024);
            f.close();
            f = new RandomAccessFile(temp, mode);
            Random random = new Random(1L);
            int minBlockSize = 256;
            int maxBlockSize = 16384;
            int blockSize = minBlockSize;
            byte[] buffer = new byte[maxBlockSize];
            boolean readOnly = false;
            String s = null;
            while (!stop) {
                if (s == null) {
                    String string = s = "r".equals(mode) || readOnly ? "read" : "write";
                }
                if (delay > 0) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                long start = System.currentTimeMillis();
                long end = start + (long)time;
                long now = start;
                int op = 0;
                while (true) {
                    if ("r".equals(mode) || readOnly) {
                        f.seek(blockSize * random.nextInt(fileSize * 1024 * 1024 / blockSize));
                        f.readFully(buffer, 0, blockSize);
                    } else {
                        f.seek(blockSize * random.nextInt(fileSize * 1024 * 1024 / blockSize));
                        random.nextBytes(buffer);
                        f.write(buffer, 0, blockSize);
                        if (sync) {
                            f.getFD().sync();
                        }
                    }
                    now = System.currentTimeMillis();
                    if (now > end) break;
                    ++op;
                }
                s = s + " " + op;
                if ((blockSize += blockSize) <= maxBlockSize) continue;
                readOnly = !readOnly;
                blockSize = minBlockSize;
                pw.flush();
                pw.print(s);
                pw.println("<br />");
                this.results.add(s);
                s = null;
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
            temp.delete();
        }
    }

    private void stop(HttpServletRequest req, HttpServletResponse res) throws IOException {
        stop = true;
        PrintWriter pw = res.getWriter();
        pw.println("<form method='post'>");
        pw.println("<div><label>Directory: <input type='text' name='directory' value='.' /></label>");
        pw.println("<p class='desc'>The test will pause this long until running the next test.</p></div>");
        pw.println("<div><label>File size (MB): <input type='text' name='fileSize' value='32' /></label>");
        pw.println("<p class='desc'>The test creates one temporary file with the given size.</p></div>");
        pw.println("<div><label>Run (ms): <input type='text' name='time' value='1000' /></label>");
        pw.println("<p class='desc'>The test will run at full speed for this many milliseconds.</p></div>");
        pw.println("<div><label>Delay (ms): <input type='text' name='delay' value='100' /></label>");
        pw.println("<p class='desc'>After running a test, there is a pause of this many milliseconds.</p></div>");
        pw.println("<div><label>File mode (r/rw/rw+): <input type='text' name='mode' value='rw' /></label>");
        pw.println("<p class='desc'>The file access mode. Use rw for read+write, r for read-only, rw+ for read+write+fsync.</p></div>");
        pw.println("<input type='hidden' name='action' value='start' />");
        pw.println("<input type='submit' value='Start Benchmark' />");
        pw.println("</form>");
        if (this.results.size() > 0) {
            pw.println("<table>");
            pw.println("<thead>");
            pw.println("<tr>");
            pw.println("<th class='type' rowspan='2'>Operation Type</th>");
            pw.println("<th class='values' colspan='7'>Operations Per Second for Block Sizes</th>");
            pw.println("</tr>");
            pw.println("<tr>");
            pw.println("<th class='value'>256 B</th>");
            pw.println("<th class='value'>512 B</th>");
            pw.println("<th class='value'>1 KB</th>");
            pw.println("<th class='value'>2 KB</th>");
            pw.println("<th class='value'>4 KB</th>");
            pw.println("<th class='value'>8 KB</th>");
            pw.println("<th class='value'>16 KB</th>");
            pw.println("</tr>");
            pw.println("</thead>");
            pw.println("<tbody>");
            for (String s : this.results) {
                String[] rows = s.split(" ");
                pw.println("<tr>");
                int i = 0;
                for (String cell : rows) {
                    if (i == 0) {
                        pw.print("<td class='type'>");
                    } else {
                        pw.print("<td class='value'>");
                    }
                    pw.print(cell);
                    pw.println("</td>");
                    ++i;
                }
                pw.println("</tr>");
            }
            pw.println("</tbody>");
            pw.println("</table>");
        }
    }

    protected String[] getCssReferences() {
        return new String[]{"/diskbenchmark/res/diskbenchmark.css"};
    }

    private URL getResource(String path) {
        return path != null && path.startsWith(RESOURCE_PREFIX) ? ((Object)((Object)this)).getClass().getResource(path.substring(RESOURCE_PREFIX.length() - 1)) : null;
    }
}

