/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console.util;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.felix.service.command.CommandSession;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;

public class Util {
    public static final String KEY_WORKSPACE = "console.workspace";
    public static final String KEY_PATH = "console.path";
    public static final String KEY_NODE_ID = "console.nodeid";
    public static final String KEY_SESSION = "console.session";
    public static final String KEY_LOGIN = "console.login";
    public static final String KEY_REPOSITORY = "console.repository";
    public static final String KEY_SHUTDOWN_REPOSITORY = "console.shutdownrepository";

    public static String formatValue(Value value, int maxLength) throws ValueFormatException, IllegalStateException, RepositoryException {
        if (value.getType() == 2) {
            return "<binary>";
        }
        String ret = value.getString();
        if (ret.length() > maxLength) {
            ret = ret.substring(0, maxLength - 3) + "...";
        }
        if (value.getType() == 1) {
            ret = "\"" + ret + "\"";
        }
        return ret;
    }

    public static Session getSession(CommandSession cmdSession, boolean warn) throws RepositoryException {
        SessionImpl ret;
        SessionImpl sessionImpl = ret = cmdSession == null ? null : (SessionImpl)((Object)cmdSession.get(KEY_SESSION));
        if (ret == null && warn) {
            throw new RepositoryException("no session available");
        }
        return ret;
    }

    public static Session getSession(CommandSession cmdSession) throws RepositoryException {
        return Util.getSession(cmdSession, true);
    }

    public static void cd(CommandSession session, String path) throws Exception {
        ItemImpl item = Util.getItem(session, path);
        if (!item.isNode()) {
            PropertyImpl prop = (PropertyImpl)item;
            if (prop.getType() == 9) {
                item = (ItemImpl)prop.getNode();
            } else {
                System.err.println("Specified path points to a property which is not referenceable.");
                return;
            }
        }
        NodeImpl currentNode = (NodeImpl)item;
        session.put(KEY_PATH, (Object)currentNode.getPath());
        session.put(KEY_NODE_ID, (Object)currentNode.getNodeId().toString());
    }

    public static ItemImpl getItem(CommandSession session, String path) throws Exception {
        Session s = Util.getSession(session);
        return (ItemImpl)s.getItem(Util.getCWD(session, path));
    }

    public static String getCWD(CommandSession session, String path) throws RepositoryException {
        String cwd = (String)session.get(KEY_PATH);
        if (path == null || path.equals("")) {
            return cwd;
        }
        if (path.startsWith("[")) {
            int idx = path.indexOf(93);
            NodeId id = NodeId.valueOf((String)path.substring(1, idx));
            SessionImpl s = (SessionImpl)((Object)session.get(KEY_SESSION));
            NodeImpl node = s.getNodeById(id);
            cwd = node.getPath();
            path = idx < path.length() - 1 ? path.substring(idx + 2) : cwd;
        }
        if (!path.startsWith("/")) {
            path = cwd.endsWith("/") ? cwd + path : cwd + "/" + path;
        }
        return path;
    }
}

