/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class Table {
    private int numCols;
    private int[] lengths;
    private LinkedList<Row> rows = new LinkedList();

    public Table(int numCols) {
        this.numCols = numCols;
        this.lengths = new int[numCols];
    }

    public Row createRow() {
        return new Row(this.numCols);
    }

    public void addRow(String c1, String c2) {
        Row r = this.createRow();
        r.addCol(c1);
        r.addCol(c2);
        this.addRow(r);
    }

    public void addRow(Row row) {
        this.rows.add(row);
        for (int i = 0; i < row.cols.length; ++i) {
            int l = ((Row)row).cols[i].value.length();
            if (l <= this.lengths[i]) continue;
            this.lengths[i] = l;
        }
    }

    public void print() {
        for (Row r : this.rows) {
            StringBuffer buf = new StringBuffer();
            r.print(buf, this.lengths);
            System.out.println(buf);
        }
    }

    public void sort(final int col) {
        Collections.sort(this.rows, new Comparator<Row>(){

            @Override
            public int compare(Row r1, Row r2) {
                return ((Row)r1).cols[col].value.compareTo(((Row)r2).cols[col].value);
            }
        });
    }

    public static class Col {
        public static final String SPACES = "                                                                                                                                                                                                                                                                                                                                                                                                              ";
        String value = "";

        public Col(String value) {
            this.value = value;
        }

        public void print(StringBuffer buf, int maxLength) {
            if (this.value.length() > maxLength) {
                buf.append(this.value.substring(0, maxLength));
            } else {
                buf.append(this.value);
                buf.append(SPACES.substring(0, maxLength - this.value.length()));
            }
            buf.append(" ");
        }
    }

    public static class Row {
        private Col[] cols;
        private int pos = 0;

        public Row(int numCols) {
            this.cols = new Col[numCols];
        }

        public void addCol(String value) {
            this.cols[this.pos++] = new Col(value);
        }

        public void print(StringBuffer buf, int[] lengths) {
            for (int i = 0; i < this.cols.length; ++i) {
                this.cols[i].print(buf, lengths[i]);
            }
        }
    }
}

