/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console.util;

import java.util.HashMap;

public class Options {
    private final String fmt;
    private String[] args = new String[0];
    private final String name;
    private int maxArgs;
    private int minArgs;
    private final HashMap<String, String[]> options = new HashMap();

    public Options(String name, String fmt, String[] args) {
        this.name = name;
        this.fmt = fmt + "  ";
        for (int i = 0; i < fmt.length(); ++i) {
            if (fmt.charAt(i) == '!') {
                ++this.minArgs;
                ++this.maxArgs;
                continue;
            }
            if (fmt.charAt(i) != '$') continue;
            ++this.maxArgs;
        }
        this.parse(args);
    }

    private void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            char c = arg.charAt(0);
            if (c == '-' && arg.length() > 1) {
                for (int j = 1; j < arg.length(); ++j) {
                    String key;
                    char opt = arg.charAt(j);
                    int idx = this.fmt.indexOf(opt);
                    if (idx < 0) {
                        throw this.error("Invalid option -" + opt + " specified.");
                    }
                    boolean multi = false;
                    if (this.fmt.charAt(idx + 1) == '*') {
                        multi = true;
                        ++idx;
                    }
                    String value = "";
                    if (this.fmt.charAt(idx + 1) == ':') {
                        if (j < arg.length() - 1) {
                            value = arg.substring(j + 1);
                            j = arg.length();
                        } else {
                            char nextOpt;
                            String nextArg;
                            if (i == args.length - 1) {
                                throw this.error("Option " + arg + " needs argument");
                            }
                            if ((nextArg = args[++i]).charAt(0) == '-' && nextArg.length() > 1 && this.fmt.indexOf(nextOpt = nextArg.charAt(1)) >= 0) {
                                throw this.error("Option " + arg + " needs argument");
                            }
                            value = args[i];
                        }
                    }
                    if (this.hasOption(key = String.valueOf(opt)) && !multi) {
                        throw this.error("Option -" + key + " can only be specified once.");
                    }
                    this.addOption(key, value);
                }
                continue;
            }
            this.args = new String[args.length - i];
            System.arraycopy(args, i, this.args, 0, this.args.length);
            break;
        }
        if (this.args.length < this.minArgs) {
            throw this.error("At least " + this.minArgs + " argument(s) expected.");
        }
        if (this.args.length > this.maxArgs) {
            throw this.error("Only " + this.maxArgs + " argument(s) expected.");
        }
    }

    private IllegalArgumentException error(String msg) {
        return new IllegalArgumentException("'" + this.name + "' " + msg);
    }

    private void addOption(String name, String value) {
        String[] opts = this.options.get(name);
        if (opts == null) {
            this.options.put(name, new String[]{value});
        } else {
            String[] newOpts = new String[opts.length + 1];
            System.arraycopy(opts, 0, newOpts, 0, opts.length);
            newOpts[opts.length] = value;
            this.options.put(name, newOpts);
        }
    }

    public String getOption(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name)[0];
        }
        return null;
    }

    public String[] getOptions(String name) {
        return this.options.get(name);
    }

    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getArg(int nr) {
        return nr < this.args.length ? this.args[nr] : null;
    }

    public String getArg(int nr, String def) {
        return nr < this.args.length ? this.args[nr] : def;
    }

    public void dump() {
        for (String key : this.options.keySet()) {
            String[] opts = this.options.get(key);
            for (int i = 0; i < opts.length; ++i) {
                System.out.println("Options: " + key + i + " = " + opts[i]);
            }
        }
        for (int i = 0; i < this.args.length; ++i) {
            System.out.println("Arg" + i + ": " + this.args[i]);
        }
    }
}

