/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console.util;

import com.adobe.granite.crx.console.util.ConsoleSession;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;

public class ConsoleNode {
    private final NodeState state;
    private final ConsoleSession session;

    public ConsoleNode(ConsoleSession session, NodeState state) {
        this.state = state;
        this.session = session;
    }

    public Path getPath() throws RepositoryException {
        return this.session.getPath(this.state);
    }

    public String getSafePath() throws RepositoryException {
        Path path = this.getPath();
        try {
            return this.session.getJCRPath(path);
        }
        catch (NamespaceException e) {
            return path.toString();
        }
    }

    public NodeState getNodeState() {
        return this.state;
    }

    public void store() throws RepositoryException {
        ChangeLog cl = new ChangeLog();
        cl.modified((ItemState)this.state);
        try {
            this.session.getPersistenceManager().store(cl);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

