/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleNode;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Table;
import javax.jcr.Item;
import javax.jcr.PropertyType;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.spi.Name;

public class CmdStat
extends AbstractCommand {
    public void stat(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] args) throws Exception {
        this.cmdSession = s;
        Options opts = this.getOptions(args);
        String path = opts.getArg(0, "");
        int flags = 0;
        NodeId id = null;
        try {
            id = new NodeId(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (id == null) {
            this.stat(path, flags);
        } else {
            this.stat(id, flags);
        }
    }

    private void stat(String path, int flags) throws Exception {
        String cwd = this.getConsoleSession().getCurrentPath(path);
        Item item = this.getSession().getItem(cwd);
        if (item.isNode()) {
            this.stat(((NodeImpl)item).getNodeId(), flags);
        } else {
            this.stat((PropertyId)((PropertyImpl)item).getId(), flags);
        }
    }

    private void stat(NodeId id, int flags) throws Exception {
        ConsoleSession s = this.getConsoleSession();
        ConsoleNode node = s.getNode(id);
        NodeState state = node.getNodeState();
        Table t = new Table(2);
        t.addRow("Path:", node.getPath().toString());
        t.addRow("NodeId:", id.toString());
        if (state.getParentId() != null) {
            t.addRow("ParentId:", state.getParentId().toString());
        } else {
            t.addRow("ParentId:", "<null>");
        }
        t.addRow("NodeTypeName:", state.getNodeTypeName().toString());
        t.addRow("Memory used:", String.valueOf(state.calculateMemoryFootprint()));
        t.print();
        System.out.println("ChildNode Entries:");
        for (ChildNodeEntry entry : state.getChildNodeEntries()) {
            System.out.println("+ " + entry.toString());
        }
        System.out.println("Property Names:");
        for (Name name : state.getPropertyNames()) {
            System.out.println("- " + name.toString());
        }
    }

    private void stat(PropertyId id, int flags) throws Exception {
        ConsoleSession s = this.getConsoleSession();
        PropertyState state = s.getProperty(id);
        Table t = new Table(2);
        t.addRow("PropertyId:", id.toString());
        if (state.getParentId() != null) {
            t.addRow("ParentId:", state.getParentId().toString());
        } else {
            t.addRow("ParentId:", "<null>");
        }
        t.addRow("Type:", PropertyType.nameFromValue((int)state.getType()));
        t.addRow("# Values:", String.valueOf(state.getValues().length));
        t.addRow("IsMulti:", String.valueOf(state.isMultiValued()));
        t.addRow("Memory used:", String.valueOf(state.calculateMemoryFootprint()));
        t.print();
    }

    public String getName() {
        return "stat";
    }

    public boolean isName(String cmd) {
        return "st".equals(cmd) || super.isName(cmd);
    }

    public String getDescription() {
        return "Prints the lowlevel (persistence) information of a node or a property.";
    }

    public String getOptionsFormat() {
        return "$";
    }

    public String getHelpString() {
        return "Synopsis:\n    stat [path | uuid]\n\nDescription:\n    Prints lowlevel (persistence) information about the given item.";
    }
}

