/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Table;
import com.adobe.granite.crx.console.util.Util;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;

public class CmdPrint
extends AbstractCommand {
    public boolean print(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] args) throws Exception {
        this.cmdSession = s;
        Options opts = this.getOptions(args);
        String path = opts.getArg(0, "");
        int flags = 0;
        this.print(path, flags);
        return true;
    }

    private void print(String path, int flags) throws Exception {
        String cwd = this.getConsoleSession().getCurrentPath(path);
        ItemImpl item = Util.getItem(this.cmdSession, cwd);
        if (item.isNode()) {
            this.print((NodeImpl)item, flags);
        } else {
            this.print((PropertyImpl)item, flags);
        }
    }

    private void print(NodeImpl node, int flags) throws RepositoryException {
        Table t = new Table(2);
        t.addRow("Path:", node.getPath());
        t.addRow("IsNew:", String.valueOf(node.isNew()));
        t.addRow("IsModified:", String.valueOf(node.isModified()));
        t.addRow("UUID:", node.getNodeId().toString());
        t.addRow("Primary NT:", node.getPrimaryNodeType().getName());
        NodeType[] mixins = node.getMixinNodeTypes();
        for (int i = 0; i < mixins.length; ++i) {
            t.addRow("Mixin NT:", mixins[i].getName());
        }
        try {
            t.addRow("IsLocked:", String.valueOf(node.isLocked()));
        }
        catch (RepositoryException e) {
            t.addRow("IsLocked:", "N/A " + (Object)((Object)e));
        }
        try {
            t.addRow("IsCheckedOut:", String.valueOf(node.isCheckedOut()));
        }
        catch (RepositoryException e) {
            t.addRow("IsCheckedOut:", "N/A " + (Object)((Object)e));
        }
        PropertyIterator iter = node.getReferences();
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            t.addRow("Referenced By:", p.getPath());
        }
        t.print();
    }

    private void print(PropertyImpl prop, int flags) throws RepositoryException {
        Table t = new Table(2);
        t.addRow("Path:", prop.getPath());
        t.addRow("IsNew:", String.valueOf(prop.isNew()));
        t.addRow("IsModified:", String.valueOf(prop.isModified()));
        t.addRow("Type:", PropertyType.nameFromValue((int)prop.getType()));
        t.addRow("IsMulti:", String.valueOf(prop.getDefinition().isMultiple()));
        if (prop.getDefinition().isMultiple()) {
            Value[] vals = prop.getValues();
            for (int i = 0; i < vals.length; ++i) {
                t.addRow("Value[" + i + "]", Util.formatValue(vals[i], 140));
            }
        } else {
            t.addRow("Value", Util.formatValue(prop.getValue(), 140));
        }
        t.print();
    }

    public String getName() {
        return "print";
    }

    public boolean isName(String cmd) {
        return "?".equals(cmd) || super.isName(cmd);
    }

    public String getDescription() {
        return "Prints the definition of a node or a property.";
    }

    public String getOptionsFormat() {
        return "$";
    }

    public String getHelpString() {
        return "Synopsis:\n    print [path]\n\nDescription:\n    Prints the definition of a node or a property.";
    }
}

