/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;

public class CmdMv
extends AbstractCommand {
    public void mv(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        String srcPath = opts.getArg(0);
        String dstPath = opts.getArg(1);
        boolean isWorkspace = opts.hasOption("w");
        ConsoleSession cs = this.getConsoleSession();
        String s = cs.getCurrentPath(srcPath);
        String d = cs.getCurrentPath(dstPath);
        if (isWorkspace) {
            this.getSession().getWorkspace().move(s, d);
        } else {
            this.getSession().move(s, d);
        }
    }

    public String getName() {
        return "mv";
    }

    public boolean isName(String cmd) {
        return "move".equals(cmd) || super.isName(cmd);
    }

    public String getDescription() {
        return "Moves a node.";
    }

    public String getOptionsFormat() {
        return "w!!";
    }

    public String getHelpString() {
        return "Synopsis:\n    mv [options] source destination\n\nDescription:\n    Moves the node at the <source> path to the specified destination.\n\nOptions:\n    -w   rather perform a workspace move than a session one.\n";
    }
}

