/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.spi.Name;

public class CmdMixin
extends AbstractCommand {
    public void mixin(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        String path = opts.getArg(0);
        HashSet<Name> add = new HashSet<Name>();
        if (opts.hasOption("a")) {
            for (String s : opts.getOptions("a")) {
                add.add(((SessionImpl)this.getSession()).getQName(s));
            }
        }
        HashSet<Name> remove = new HashSet<Name>();
        if (opts.hasOption("r")) {
            for (String s : opts.getOptions("r")) {
                remove.add(((SessionImpl)this.getSession()).getQName(s));
            }
        }
        NodeImpl node = (NodeImpl)Util.getItem(this.cmdSession, path);
        Iterator iter = add.iterator();
        while (iter.hasNext()) {
            node.addMixin((Name)iter.next());
        }
        iter = remove.iterator();
        while (iter.hasNext()) {
            node.removeMixin((Name)iter.next());
        }
    }

    public String getName() {
        return "mixin";
    }

    public String getDescription() {
        return "Manipulates the set of mixin nodetypes of a node.";
    }

    public String getOptionsFormat() {
        return "a:r:$";
    }

    public String getHelpString() {
        return "Synopsis:\n    mixin {-a mixin |-r mixin } [path]\n\nDescription:\n    Adds or removes the specified mixin from the set of mixing\n    nodetypes of the specified node.\n\nCommands:\n    -a mixin   adds the specified mixin nodetype (can be multiple)\n    -r mixin   removes the specified mixin nodetype (can be multiple)\n";
    }
}

