/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Table;
import com.adobe.granite.crx.console.util.Util;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;

public class CmdLs
extends AbstractCommand {
    private static final int LS_FLAG_DEF = 1;
    private static final int LS_FLAG_NT = 2;
    private static final int LS_FLAG_UUID = 4;
    private static final int LS_FLAG_LONG = 7;
    private static final int LS_FLAG_VALUES = 8;

    public void ls(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] opts) throws Exception {
        this.cmdSession = s;
        Options o = this.getOptions(opts);
        String path = o.getArg(0);
        int flags = 0;
        int depth = 1;
        flags |= o.hasOption("l") ? 7 : 0;
        flags |= o.hasOption("p") ? 2 : 0;
        flags |= o.hasOption("v") ? 8 : 0;
        flags |= o.hasOption("d") ? 1 : 0;
        flags |= o.hasOption("u") ? 4 : 0;
        if (o.hasOption("r")) {
            try {
                depth = Integer.parseInt(o.getOption("r"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.ls(path, flags, depth);
    }

    private void ls(String path, int flags, int maxDepth) throws Exception {
        int numCols = 1;
        for (int f = flags; f != 0; f >>= 1) {
            if ((f & 1) != 1) continue;
            ++numCols;
        }
        Table t = new Table(numCols);
        ItemImpl cwi = Util.getItem(this.cmdSession, path);
        if (cwi.isNode()) {
            this.ls(t, (NodeImpl)cwi, flags, 0, maxDepth);
        } else {
            this.ls(t, (PropertyImpl)cwi, flags, 0);
        }
        t.print();
    }

    private void ls(Table t, NodeImpl node, int flags, int indent, int maxDepth) throws RepositoryException {
        Table.Row r = t.createRow();
        NodeDefinition def = node.getDefinition();
        if ((flags & 1) > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(def.isAutoCreated() ? "a" : "-");
            buf.append(def.isMandatory() ? "m" : "-");
            buf.append(def.isProtected() ? "p" : "-");
            buf.append(def.allowsSameNameSiblings() ? "s " : "- ");
            buf.append(OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()).substring(0, 3));
            r.addCol(buf.toString());
        }
        if ((flags & 4) > 0) {
            r.addCol(node.getNodeId().toString());
        }
        if ((flags & 2) > 0) {
            r.addCol(node.getPrimaryNodeType().getName());
        }
        String mode = " + ";
        if (node.isModified()) {
            mode = "*+ ";
        } else if (node.isNew()) {
            mode = "++ ";
        }
        mode = "                                                                                                                                                                                                                                                                                                                                                                                                              ".substring(0, indent * 2) + mode;
        if (node.getName().equals("")) {
            mode = mode + "/";
        }
        r.addCol(mode + node.getName());
        if ((flags & 8) > 0) {
            r.addCol("");
        }
        t.addRow(r);
        if (maxDepth > 0) {
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                this.ls(t, (NodeImpl)iter.nextNode(), flags, indent + 1, maxDepth - 1);
            }
            PropertyIterator piter = node.getProperties();
            while (piter.hasNext()) {
                this.ls(t, (PropertyImpl)piter.nextProperty(), flags, indent + 1);
            }
        }
    }

    private void ls(Table t, PropertyImpl prop, int flags, int indent) throws RepositoryException {
        Table.Row r = t.createRow();
        PropertyDefinition def = prop.getDefinition();
        if ((flags & 1) > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(def.isAutoCreated() ? "a" : "-");
            buf.append(def.isMandatory() ? "m" : "-");
            buf.append(def.isProtected() ? "p  " : "-  ");
            buf.append(OnParentVersionAction.nameFromValue((int)def.getOnParentVersion()).substring(0, 3));
            r.addCol(buf.toString());
        }
        if ((flags & 4) > 0) {
            r.addCol("");
        }
        if ((flags & 2) > 0) {
            r.addCol(PropertyType.nameFromValue((int)prop.getType()) + (def.isMultiple() ? "[]" : ""));
        }
        String mode = " - ";
        if (prop.isModified()) {
            mode = "*- ";
        } else if (prop.isNew()) {
            mode = "-- ";
        }
        mode = "                                                                                                                                                                                                                                                                                                                                                                                                              ".substring(0, indent * 2) + mode;
        r.addCol(mode + prop.getName());
        if ((flags & 8) > 0) {
            if (def.isMultiple()) {
                Value[] vals = prop.getValues();
                StringBuffer buf = new StringBuffer();
                buf.append("{");
                for (int i = 0; i < vals.length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(Util.formatValue(vals[i], 140));
                }
                buf.append("}");
                r.addCol(buf.toString());
            } else {
                r.addCol(Util.formatValue(prop.getValue(), 140));
            }
        }
        t.addRow(r);
    }

    public String getName() {
        return "ls";
    }

    public String getDescription() {
        return "Prints the list of nodes of properties.";
    }

    public String getOptionsFormat() {
        return "pvdulr:$";
    }

    public String getHelpString() {
        return "Synopsis:\n    ls [option] [path]\n\nDescription:\n    List information about the nodes and properties of the node\n    at <path>.\n\nOptions:\n    -p   include primary nodetype\n    -v   include property values\n    -d   include item definition information\n    -u   include uuid information for nodes\n    -l   combines options p, d, u\n    -rN  does a recursive list, with maxdepth of N.\n";
    }
}

