/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.sling.server.ExclusiveAccess;
import com.day.crx.sling.server.PropertyAccess;
import java.io.File;
import javax.jcr.Session;
import org.apache.felix.scr.Component;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.osgi.service.component.ComponentContext;

public class CmdLogout
extends AbstractCommand {
    private File homeDir;

    public void activate(ComponentContext context) {
        PropertyAccess pa = new PropertyAccess(context);
        this.homeDir = new File(pa.getProperty("repository.home")).getAbsoluteFile();
    }

    public void deactivate(ComponentContext context) {
        Component c;
        CRXRepositoryImpl rep = (CRXRepositoryImpl)this.cmdSession.get("console.shutdownrepository");
        if (rep != null) {
            rep.shutdown();
        }
        if ((c = (Component)this.cmdSession.get("console.repository")) != null && c.getState() != 16 && c.getState() != 8) {
            System.out.println("reenabling repository...");
            c.enable();
            System.out.println("done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] a) throws Exception {
        ExclusiveAccess.stopExclusiveAccess(this.homeDir);
        this.cmdSession = s;
        try {
            Session oldSession = this.getSession(true);
            if (oldSession != null) {
                oldSession.logout();
                System.out.println("Session logout performed.");
            }
        }
        finally {
            this.cmdSession.put("console.session", null);
        }
    }

    public String getName() {
        return "logout";
    }

    public String getDescription() {
        return "Perform a logout on the repository.";
    }

    public String getHelpString() {
        return "Synopsis:\n    logout\n\nDescription:\n    Performs a logout on the repository.";
    }
}

