/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.Command;
import com.adobe.granite.crx.console.CommandFactory;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Table;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;

public class CmdHelp
extends AbstractCommand {
    public void help(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] opts) throws Exception {
        this.cmdSession = s;
        Options o = this.getOptions(opts);
        String cmdName = o.getArg(0);
        boolean detail = o.hasOption("d");
        if (cmdName == null) {
            System.out.println("\nAvailable commands:");
            if (detail) {
                for (Command c : CommandFactory.getAvailableCommands()) {
                    System.out.println("-------------------------------");
                    System.out.println(c.getName());
                    System.out.println("    " + c.getDescription());
                    System.out.println("\n");
                    System.out.println(c.getHelpString());
                }
            } else {
                Table t = new Table(2);
                for (Command c : CommandFactory.getAvailableCommands()) {
                    t.addRow("  " + c.getName(), c.getDescription());
                }
                t.sort(0);
                t.print();
            }
            System.out.println("\nPaths:\n  Paths can be specified either\n  - relative to the cwd (i.e. './foo/bar')\n  - absolute (i.e. '/foo/bar')\n  - or uuid-relative (i.e. '[cafebabe-cafe-babe-cafe-babecafebabe]/foo/bar')");
            System.out.println("\nUse 'help -d' to list the details for all commands or\nuse 'help <cmd>' for a specific command.");
        } else {
            Command cmd = CommandFactory.getCommand(cmdName);
            if (cmd == null) {
                System.out.println("No such command: " + cmdName);
            } else {
                System.out.println(cmd.getHelpString());
            }
        }
    }

    public String getName() {
        return "help";
    }

    public String getDescription() {
        return "Prints this help";
    }

    public String getOptionsFormat() {
        return "d$";
    }

    public String getHelpString() {
        return "Synopsis:\n    help [options] [cmd]\n\nDescription:\n    Prints a more detailed infomation about the specified\n    command. If <cmd> is empty, all available commands are listed.\nOptions:\n    -d   print details for all commands\n";
    }
}

