/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import com.day.crx.core.CRXRepositoryImpl;
import com.day.crx.sling.server.ExclusiveAccess;
import com.day.crx.sling.server.PropertyAccess;
import com.day.crx.sling.server.impl.jmx.ManagedRepository;
import java.io.File;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Workspace;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.RepositoryContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class CmdConnect
extends AbstractCommand {
    private Component managedRepository;
    private File homeDir;
    private File configFile;

    public void activate(ComponentContext context) {
        ServiceReference scrServiceRef;
        int i$ = 0;
        BundleContext bundleContext = context.getBundleContext();
        ScrService scrService = (ScrService)bundleContext.getService(scrServiceRef = bundleContext.getServiceReference(ScrService.class.getName()));
        Component[] components = scrService.getComponents(ManagedRepository.class.getName());
        Component[] arr$ = components;
        int len$ = arr$.length;
        if (i$ < len$) {
            Component c;
            this.managedRepository = c = arr$[i$];
        }
        PropertyAccess pa = new PropertyAccess(context);
        this.homeDir = new File(pa.getProperty("repository.home")).getAbsoluteFile();
        this.configFile = new File(pa.getProperty("repository.config")).getAbsoluteFile();
    }

    public void connect(@Descriptor(value="automatically supplied shell session") CommandSession s, String[] a) throws Exception {
        this.cmdSession = s;
        this.cmdSession.put("console.repository", null);
        boolean repositoryStopped = false;
        Options opts = this.getOptions(a);
        String[] args = opts.getArgs();
        if (this.homeDir != null && this.configFile != null) {
            if (ExclusiveAccess.isLocked(this.homeDir)) {
                System.err.println("Repository is locked by another console.");
                return;
            }
        } else {
            System.err.println("Can't connect. Repository home directory and config file must be configured.");
            return;
        }
        System.out.println("repository file: " + this.configFile);
        System.out.println("home directory:  " + this.homeDir);
        if (this.managedRepository != null && (this.managedRepository.getState() == 16 || this.managedRepository.getState() == 8)) {
            if (opts.hasOption("f")) {
                this.cmdSession.put("console.repository", (Object)this.managedRepository);
                this.managedRepository.disable();
                repositoryStopped = true;
                System.out.println("Repository was disabled!");
            } else {
                System.err.println("Repository is active! Can't start single user mode.");
                return;
            }
        }
        if (!ExclusiveAccess.startExclusiveAccess(this.homeDir)) {
            System.err.println("Can't access repository exclusively!");
            if (repositoryStopped) {
                this.cmdSession.put("console.repository", null);
                this.managedRepository.enable();
            }
            return;
        }
        String wsp = null;
        String user = null;
        String pw = null;
        if (opts.hasOption("w")) {
            wsp = opts.getOption("w");
        }
        if (args.length > 0) {
            user = args[0];
            pw = args.length > 1 ? args[1] : "";
        }
        this.login(user == null ? null : new SimpleCredentials(user, pw.toCharArray()), wsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(SimpleCredentials creds, String ws) throws Exception {
        RepositoryContext context = null;
        CRXRepositoryImpl repository = null;
        boolean ok = false;
        try {
            context = CRXRepositoryImpl.create((File)this.homeDir, (File)this.configFile);
            repository = (CRXRepositoryImpl)context.getRepository();
            Session s = null;
            s = creds == null ? (ws == null ? repository.login() : repository.login(ws)) : (ws == null ? repository.login((Credentials)creds) : repository.login((Credentials)creds, ws));
            if (s != null) {
                ok = true;
                this.cmdSession.put("console.session", (Object)s);
                this.cmdSession.put("console.login", (Object)s.getUserID());
                this.cmdSession.put("console.shutdownrepository", (Object)repository);
                System.out.print("successfully logged in as user " + s.getUserID());
                this.cmdSession.put("console.workspace", s.getWorkspace() == null ? null : s.getWorkspace().getName());
                Workspace wsp = s.getWorkspace();
                System.out.println(wsp == null ? "." : " in workspace " + wsp.getName());
                System.out.println();
                System.out.println("Please logout to stop the exclusive access to the repository!");
                Util.cd(this.cmdSession, "/");
            } else {
                System.err.println("Couldn't login");
            }
        }
        finally {
            if (!ok && repository != null) {
                repository.shutdown();
                ExclusiveAccess.stopExclusiveAccess(this.homeDir);
            }
        }
    }

    public String getName() {
        return "connect";
    }

    public String getDescription() {
        return "Connects to a CRXRepository.";
    }

    public String getOptionsFormat() {
        return "fw:$$";
    }

    public String getHelpString() {
        return "Synopsis:\n    connect [user] [pass]\n\nDescription:\n    Connects to a CRXRepository using the specfied\n    user and password if no repository component is running.\n    This command should be used for repair purposes only.\n    The repository component can't be used until a logout is performed!\n\nOptions:\n    -f force shutdown of running repository manager\n    -w name workspace\n";
    }
}

