/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.Table;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

public class CmdCheck
extends AbstractCommand {
    public void check(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Session s = this.getSession();
        String wsp = s.getWorkspace().getName();
        PersistenceManager srcPm = this.getConsoleSession(wsp).getPersistenceManager();
        NodeId rootNodeId = ((NodeImpl)this.getSession().getRootNode()).getNodeId();
        Checker r = new Checker((SessionImpl)this.getSession(), srcPm);
        try {
            r.scan(rootNodeId);
            Table t = new Table(2);
            t.addRow("Number of nodes:", String.valueOf(r.getNumNodes()));
            t.addRow("Number of single-value props:", String.valueOf(r.getNumSVProps()));
            t.addRow("Number of multi-value props:", String.valueOf(r.getNumMVProps()));
            long[] vals = r.getNumValues();
            long total = 0L;
            for (int i = 0; i < vals.length; ++i) {
                t.addRow("Number of " + PropertyType.nameFromValue((int)i) + " values:", String.valueOf(vals[i]));
                total += vals[i];
            }
            t.addRow("Total number of values:", String.valueOf(total));
            t.addRow("Total bytes in values:", String.valueOf(r.getTotalPropSize()));
            t.print();
        }
        catch (Exception e) {
            System.err.println("Error occurred during check: " + e.toString());
        }
    }

    public String getOptionsFormat() {
        return "";
    }

    public String getName() {
        return "check";
    }

    public String getDescription() {
        return "Checks the repository";
    }

    public String getHelpString() {
        return "Synopsis:\n    check [options]\n\nDescription:\n    Checks the repository for type definition errors and collects statistics.\n\n";
    }

    private class Checker {
        private long totalPropSize;
        private long numSVProps;
        private long numMVProps;
        private long[] numValues = new long[13];
        private long numNodes;
        PersistenceManager pm;
        NamePathResolver resolver;

        public Checker(SessionImpl s, PersistenceManager pm) {
            this.pm = pm;
            this.resolver = s;
        }

        public void scanProperties(NodeState state, String path) {
            for (Name name : state.getPropertyNames()) {
                PropertyId id = new PropertyId(state.getNodeId(), name);
                this.scanProperty(state, path, id);
            }
        }

        public void scanProperty(NodeState parent, String parentPath, PropertyId id) {
            PropertyState state;
            String jcrName;
            try {
                jcrName = this.resolver.getJCRName(id.getName());
            }
            catch (NamespaceException e) {
                jcrName = id.getName().toString();
                this.logError(parentPath + "/" + jcrName, "Can't resolve qname", (Exception)((Object)e));
            }
            String path = parentPath + "/" + jcrName;
            try {
                state = this.pm.load(id);
            }
            catch (ItemStateException e) {
                this.logError(path, "Unable to load property", (Exception)((Object)e));
                return;
            }
            if (state.isMultiValued()) {
                ++this.numMVProps;
            } else {
                ++this.numSVProps;
            }
            InternalValue[] values = state.getValues();
            for (int i = 0; i < values.length; ++i) {
                InternalValue val = values[i];
                int n = val.getType();
                this.numValues[n] = this.numValues[n] + 1L;
                if (val.getType() != 9) continue;
                try {
                    this.pm.load(val.getNodeId());
                    continue;
                }
                catch (Exception e) {
                    this.logError(path, i, "Reference target does not exist", e);
                }
            }
        }

        public void scanNodes(NodeState parent, String parentPath) {
            List cne = parent.getChildNodeEntries();
            for (ChildNodeEntry entry : cne) {
                String jcrName;
                try {
                    jcrName = this.resolver.getJCRName(entry.getName());
                }
                catch (NamespaceException e) {
                    jcrName = entry.getName().toString();
                    this.logError(parentPath + "/" + jcrName, "Can't resolve qname", (Exception)((Object)e));
                }
                this.scanNode(parent, parentPath, entry.getId(), entry.getName(), parentPath + "/" + jcrName);
            }
        }

        public void scanNode(NodeState parent, String parentPath, NodeId id, Name name, String path) {
            ++this.numNodes;
            try {
                NodeState state = this.pm.load(id);
                this.scanProperties(state, path);
                this.scanNodes(state, path);
            }
            catch (ItemStateException e) {
                this.logError(path, "Unable to load node", (Exception)((Object)e));
            }
        }

        public void scan(NodeId rootNodeId) throws RepositoryException {
            this.scanNode(null, null, rootNodeId, null, "");
        }

        public long getTotalPropSize() {
            return this.totalPropSize;
        }

        public long getNumSVProps() {
            return this.numSVProps;
        }

        public long getNumMVProps() {
            return this.numMVProps;
        }

        public long[] getNumValues() {
            return this.numValues;
        }

        public long getNumNodes() {
            return this.numNodes;
        }

        private void logError(String path, String msg, Exception e) {
            System.err.println(msg + " at path=" + path + ":" + e.toString());
        }

        private void logError(String path, int idx, String msg, Exception e) {
            System.err.println(msg + ". Index " + idx + " at path " + path + ":" + e.toString());
        }
    }
}

