/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.crx.console;

import com.adobe.granite.crx.console.AbstractCommand;
import com.adobe.granite.crx.console.util.ConsoleNode;
import com.adobe.granite.crx.console.util.ConsoleSession;
import com.adobe.granite.crx.console.util.Options;
import com.adobe.granite.crx.console.util.Util;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;

public class CmdAdd
extends AbstractCommand {
    public void add(@Descriptor(value="automatically supplied shell session") CommandSession ses, String[] args) throws Exception {
        this.cmdSession = ses;
        Options opts = this.getOptions(args);
        Name nodeType = null;
        NodeId id = null;
        NodeId childId = null;
        HashSet<Name> mixins = new HashSet<Name>();
        if (opts.hasOption("c")) {
            childId = new NodeId(opts.getOption("c"));
        }
        if (opts.hasOption("n")) {
            if (childId != null) {
                System.err.println("No node types can be specified with the -c option.");
                return;
            }
            nodeType = ((SessionImpl)this.getSession()).getQName(opts.getOption("n"));
        }
        if (opts.hasOption("u")) {
            if (childId != null) {
                System.err.println("No uuid can be specified with the -c option.");
                return;
            }
            id = new NodeId(opts.getOption("u"));
        }
        if (opts.hasOption("m")) {
            if (childId != null) {
                System.err.println("No mixin node types can be specified with the -c option.");
                return;
            }
            String[] o = opts.getOptions("m");
            for (int i = 0; i < o.length; ++i) {
                mixins.add(((SessionImpl)this.getSession()).getQName(o[i]));
            }
        }
        Name name = ((SessionImpl)this.getSession()).getQName(opts.getArgs()[0]);
        NodeImpl cwd = (NodeImpl)Util.getItem(this.cmdSession, "");
        try {
            if (childId == null) {
                NodeImpl node = cwd.addNode(name, nodeType, id);
                Iterator iter = mixins.iterator();
                while (iter.hasNext()) {
                    node.addMixin((Name)iter.next());
                }
            } else {
                ConsoleSession s = this.getConsoleSession();
                ConsoleNode node = s.getNode(cwd.getNodeId());
                NodeState state = node.getNodeState();
                if (state.hasChildNodeEntry(childId)) {
                    System.err.println("Childnode entry already exists as: " + state.getChildNodeEntry(childId));
                } else {
                    state.addChildNodeEntry(name, childId);
                    state.setStatus(2);
                    node.store();
                    System.out.println("Changes were written directly to the persistence layer.");
                    System.out.println("It is advisable to logout and login again.");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Can't add node: " + e.toString());
        }
    }

    public String getName() {
        return "add";
    }

    public String getDescription() {
        return "Adds a new node or child node entry.";
    }

    public String getOptionsFormat() {
        return "n:m*:c:u:!";
    }

    public String getHelpString() {
        return "Synopsis:\n    add [options] name\n\nDescription:\n    Adds a new node to the current one.\n\nOptions:\n    -n nodetype   use the specified primary nodetype\n    -m nodetype   add the specified mixin nodetype (can be multiple)\n    -u uuid       use the specified uuid\n    -c uuid       argument is a uuid of a child node entry (experts only!)\n";
    }
}

