/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.result;

import com.day.crx.statistics.Report;
import com.day.crx.statistics.result.ResultSelected;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;

public class ResultQualityReport
extends Report {
    private int period = 12;
    private final String path;

    public ResultQualityReport(String dataPath, String path) {
        super(dataPath);
        this.path = path;
    }

    public Iterator getResult(Session session) throws RepositoryException {
        ResultSelected rs = new ResultSelected(this.getDataPath(), this.path, 1L, "");
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.add(2, -(this.getPeriod() - 1));
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (int i = 0; i < this.getPeriod(); ++i) {
            Item item;
            rs.setTimestamp(cal.getTimeInMillis());
            String p = Text.getRelativeParent((String)rs.getPath(), (int)1);
            long count = 0L;
            double position = 0.0;
            if (session.itemExists(p) && (item = session.getItem(p)).isNode()) {
                Node month = (Node)item;
                NodeIterator days = month.getNodes();
                while (days.hasNext()) {
                    Node d = days.nextNode();
                    long c = d.getProperty("count").getLong();
                    double ap = d.getProperty("avgPosition").getDouble();
                    count += c;
                    position += ap * (double)c;
                }
            }
            Long avgPosition = new Long(0L);
            if (count != 0L) {
                avgPosition = new Long((long)(position / (double)count));
            }
            data.add(new Object[]{p, avgPosition});
            cal.add(2, 1);
        }
        return data.iterator();
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

