/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.dbm;

import java.io.IOException;
import org.w3c.tools.dbm.LRUEntry;
import org.w3c.tools.dbm.jdbm;
import org.w3c.tools.dbm.jdbmBucket;

class LRUList {
    LRUEntry head = null;
    LRUEntry tail = null;

    synchronized void removeEntry(LRUEntry lru) {
        if (lru == this.head) {
            this.head = lru.next;
            lru.next = null;
            lru.prev = null;
            if (this.tail == lru) {
                this.tail = null;
            }
        } else if (lru == this.tail) {
            this.tail = lru.prev;
            this.tail.next = null;
            lru.next = null;
            lru.prev = null;
        } else {
            lru.prev.next = lru.next;
            lru.next.prev = lru.prev;
            lru.next = null;
            lru.prev = null;
        }
    }

    private final synchronized void atTop(LRUEntry lru) {
        if (lru == this.head) {
            return;
        }
        this.removeEntry(lru);
        lru.next = this.head;
        lru.prev = null;
        this.head.prev = lru;
        this.head = lru;
    }

    protected final void notifyUses(LRUEntry lru) {
        this.atTop(lru);
    }

    protected LRUEntry getLRU() {
        LRUEntry lru = this.tail;
        if (lru != null) {
            this.removeEntry(lru);
        }
        return lru;
    }

    protected synchronized LRUEntry addEntry(jdbmBucket bucket) {
        LRUEntry lru = new LRUEntry(bucket);
        lru.next = this.head;
        if (this.head != null) {
            this.head.prev = lru;
        }
        lru.prev = null;
        this.head = lru;
        if (this.tail == null) {
            this.tail = this.head;
        }
        return lru;
    }

    protected synchronized void removeBucket(jdbmBucket bucket) {
        LRUEntry lru = this.head;
        while (lru != null) {
            if (lru.bucket == bucket) {
                this.removeEntry(lru);
                return;
            }
            lru = lru.next;
        }
    }

    protected synchronized LRUEntry lookupBucket(int fileptr) {
        LRUEntry lru = this.head;
        while (lru != null) {
            if (lru.bucket.fileptr == fileptr) {
                return lru;
            }
            lru = lru.next;
        }
        return null;
    }

    protected synchronized void saveModified(jdbm db) throws IOException {
        LRUEntry lru = this.head;
        while (lru != null) {
            if (lru.bucket.modified) {
                db.saveBucket(lru.bucket);
            }
            lru = lru.next;
        }
    }

    LRUList() {
    }
}

