/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.query.lucene;

import com.day.crx.core.query.lucene.CRXSimilarity;
import com.day.crx.core.query.lucene.OnWorkspaceInconsistency;
import com.day.crx.query.lucene.CRXAnalyzer;
import com.day.crx.query.lucene.NodeIndexer;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.jackrabbit.commons.iterator.FilterIterator;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterNode;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordDeserializer;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.PrivilegeRecord;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.IndexingConfigurationEntityResolver;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.lucene.document.Document;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class LuceneHandler
extends SearchIndex {
    private static final Logger log = LoggerFactory.getLogger(LuceneHandler.class);
    private static final String DEFAULT_INDEXING_CONFIG = "indexing_config.xml";
    private Element indexingConfiguration;
    private Parser parser;

    public LuceneHandler() {
        this.setOnWorkspaceInconsistency(OnWorkspaceInconsistency.FIX.getName());
        this.setSimilarityClass(CRXSimilarity.class.getName());
        this.setAnalyzer(CRXAnalyzer.class.getName());
        this.setExtractorPoolSize(2);
        this.setSupportHighlighting(true);
        this.setSpellCheckerClass("com.day.crx.core.query.spell.CRXSpellChecker");
        this.setUseSimpleFSDirectory(true);
        try {
            TikaConfig config = new TikaConfig(SearchIndex.class.getResourceAsStream("tika-config.xml"));
            this.parser = new AutoDetectParser(config);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpecte Tika configuration error", e);
        }
    }

    public boolean isDisableAutoTextExtraction() {
        return false;
    }

    public void setDisableAutoTextExtraction(boolean disableAutoTextExtraction) {
        log.warn("The disableAutoTextExtraction configuration option is no longer supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackToRevision(ClusterNode clusterNode, long revision, String workspaceName) throws RepositoryException, JournalException, IOException {
        Journal journal = clusterNode.getJournal();
        String id = clusterNode.getId();
        ClusterRecordDeserializer deserializer = new ClusterRecordDeserializer();
        RecordProcessor processor = new RecordProcessor();
        RecordIterator records = journal.getRecords(revision);
        try {
            while (records.hasNext()) {
                Record rec = records.nextRecord();
                if (!id.equals(rec.getProducerId())) continue;
                ClusterRecord cr = deserializer.deserialize(rec);
                String wsp = cr.getWorkspace();
                if (workspaceName == null ? wsp != null : !workspaceName.equals(wsp)) continue;
                cr.process((ClusterRecordProcessor)processor);
            }
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            records.close();
            throw throwable;
        }
        records.close();
        Set<NodeId> remove = processor.getAffectedIds();
        if (remove.isEmpty()) {
            return;
        }
        final PersistenceManager pm = this.getContext().getPersistenceManager();
        FilterIterator existing = new FilterIterator(remove.iterator(), new Predicate(){

            public boolean evaluate(Object o) {
                try {
                    return pm.exists((NodeId)o);
                }
                catch (ItemStateException e) {
                    log.warn("Exception while checking if node with id " + o + " still exists.", (Throwable)e);
                    return false;
                }
            }
        });
        TransformIterator it = new TransformIterator((Iterator)existing, new Transformer(){

            public Object transform(Object input) {
                try {
                    return pm.load((NodeId)input);
                }
                catch (ItemStateException e) {
                    log.warn("Exception while loading node with id " + input + ".", (Throwable)e);
                    return null;
                }
            }
        });
        this.updateNodes(remove.iterator(), (Iterator)it);
    }

    protected Document createDocument(NodeState node, NamespaceMappings nsMappings, IndexFormatVersion indexFormatVersion) throws RepositoryException {
        NodeIndexer indexer = new NodeIndexer(node, this.getContext().getItemStateManager(), nsMappings, this.getContext().getExecutor(), this.parser);
        indexer.setSupportHighlighting(this.getSupportHighlighting());
        indexer.setIndexingConfiguration(this.getIndexingConfig());
        indexer.setIndexFormatVersion(indexFormatVersion);
        indexer.setMaxExtractLength(this.getMaxExtractLength());
        Document doc = indexer.createDoc();
        this.mergeAggregatedNodeIndexes(node, doc, indexFormatVersion);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Element getIndexingConfigurationDOM() {
        block15: {
            block14: {
                if (this.indexingConfiguration != null) {
                    return this.indexingConfiguration;
                }
                String indexingConfigPath = this.getIndexingConfiguration();
                if (indexingConfigPath != null) break block15;
                InputStream is = LuceneHandler.class.getResourceAsStream(DEFAULT_INDEXING_CONFIG);
                if (is == null) {
                    return super.getIndexingConfigurationDOM();
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver((EntityResolver)new IndexingConfigurationEntityResolver());
                this.indexingConfiguration = builder.parse(is).getDocumentElement();
                Object var6_8 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {}
                break block14;
                {
                    catch (ParserConfigurationException e) {
                        log.warn("Unable to create XML parser", (Throwable)e);
                        Object var6_9 = null;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {}
                        break block14;
                    }
                    catch (IOException e) {
                        log.warn("Exception parsing " + indexingConfigPath, (Throwable)e);
                        Object var6_10 = null;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {}
                        break block14;
                    }
                    catch (SAXException e) {
                        log.warn("Exception parsing " + indexingConfigPath, (Throwable)e);
                        Object var6_11 = null;
                        try {
                            is.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            return this.indexingConfiguration;
        }
        return super.getIndexingConfigurationDOM();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RecordProcessor
    implements ClusterRecordProcessor {
        private final Set<NodeId> ids = new HashSet<NodeId>();

        private RecordProcessor() {
        }

        Set<NodeId> getAffectedIds() {
            return this.ids;
        }

        public void process(ChangeLogRecord record) {
            for (EventState e : record.getEvents()) {
                NodeId id = e.getChildId();
                if (id != null) {
                    this.ids.add(id);
                    continue;
                }
                this.ids.add(e.getParentId());
            }
        }

        public void process(LockRecord record) {
        }

        public void process(NamespaceRecord record) {
        }

        public void process(NodeTypeRecord record) {
        }

        public void process(PrivilegeRecord record) {
        }

        public void process(WorkspaceRecord record) {
        }
    }
}

