/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.query.lucene;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public abstract class CompoundWordTokenFilter
extends TokenFilter {
    private final TermAttribute termAtt;
    private final OffsetAttribute offsetAtt;
    private final FlagsAttribute flagsAtt;
    private final PositionIncrementAttribute posIncAtt;
    private final TypeAttribute typeAtt;
    private final PayloadAttribute payloadAtt;
    private final LinkedList<Token> tokens;
    private final Token wrapper = new Token();

    protected CompoundWordTokenFilter(TokenStream input) {
        super(input);
        this.tokens = new LinkedList();
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
        this.posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        this.payloadAtt = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public boolean incrementToken() throws IOException {
        if (!this.tokens.isEmpty()) {
            this.setToken(this.tokens.removeFirst());
            return true;
        }
        if (!this.input.incrementToken()) {
            return false;
        }
        this.wrapper.setTermBuffer(this.termAtt.termBuffer(), 0, this.termAtt.termLength());
        this.wrapper.setStartOffset(this.offsetAtt.startOffset());
        this.wrapper.setEndOffset(this.offsetAtt.endOffset());
        this.wrapper.setFlags(this.flagsAtt.getFlags());
        this.wrapper.setType(this.typeAtt.type());
        this.wrapper.setPositionIncrement(this.posIncAtt.getPositionIncrement());
        this.wrapper.setPayload(this.payloadAtt.getPayload());
        this.decompose(this.wrapper);
        if (this.tokens.isEmpty()) {
            return false;
        }
        this.setToken(this.tokens.removeFirst());
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
    }

    protected abstract void decompose(Token var1);

    private void setToken(Token token) throws IOException {
        this.clearAttributes();
        this.termAtt.setTermBuffer(token.termBuffer(), 0, token.termLength());
        this.flagsAtt.setFlags(token.getFlags());
        this.typeAtt.setType(token.type());
        this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
        this.posIncAtt.setPositionIncrement(token.getPositionIncrement());
        this.payloadAtt.setPayload(token.getPayload());
    }
}

