/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.query.lucene;

import com.day.crx.query.lucene.CompoundWordTokenFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class CRXAnalyzer
extends Analyzer {
    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(Version.LUCENE_30, reader);
        result = new StandardFilter(Version.LUCENE_30, (TokenStream)result);
        result = new CRXFilter((TokenStream)result);
        result = new LowerCaseFilter(Version.LUCENE_30, (TokenStream)result);
        return result;
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new StandardTokenizer(Version.LUCENE_30, reader);
            streams.filteredTokenStream = new StandardFilter(Version.LUCENE_30, (TokenStream)streams.tokenStream);
            streams.filteredTokenStream = new CRXFilter(streams.filteredTokenStream);
            streams.filteredTokenStream = new LowerCaseFilter(Version.LUCENE_30, streams.filteredTokenStream);
        } else {
            streams.tokenStream.reset(reader);
        }
        return streams.filteredTokenStream;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CRXFilter
    extends CompoundWordTokenFilter {
        private static final String NUM_TYPE = StandardTokenizer.TOKEN_TYPES[6];
        private static final String HOST_TYPE = StandardTokenizer.TOKEN_TYPES[5];
        private static final int[] NUM_SEPARATORS = new int[]{95, 45, 47, 46, 44};
        private static final int[] HOST_SEPARATORS = new int[]{46};

        protected CRXFilter(TokenStream input) {
            super(input);
        }

        @Override
        protected void decompose(Token token) {
            if (token.type().equals(NUM_TYPE)) {
                this.split(token, NUM_SEPARATORS);
            } else if (token.type().equals(HOST_TYPE)) {
                this.split(token, HOST_SEPARATORS);
            } else {
                this.addToken(token);
            }
        }

        private void split(Token token, int[] separators) {
            ArrayList<Token> src = new ArrayList<Token>();
            src.add(token);
            ArrayList<Token> dest = new ArrayList<Token>();
            for (int separator : separators) {
                for (Token srcToken : src) {
                    CRXFilter.split(srcToken, separator, dest);
                }
                src = dest;
                dest = new ArrayList();
            }
            for (Token t : src) {
                this.addToken(t);
            }
        }

        private static void split(Token t, int separator, List<Token> parts) {
            int idx;
            int startIdx = 0;
            int offset = t.startOffset();
            String text = new String(t.termBuffer(), 0, t.termLength());
            while ((idx = text.indexOf(separator, startIdx)) != -1) {
                String s = text.substring(startIdx, idx);
                parts.add(new Token(s, offset + startIdx, offset + idx));
                startIdx = idx + 1;
            }
            parts.add(new Token(text.substring(startIdx), offset + startIdx, t.endOffset()));
        }
    }

    private static final class SavedStreams {
        StandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

