/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.index.EndMark;
import com.day.crx.persistence.tar.index.Index;
import com.day.crx.persistence.tar.index.IndexEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.core.id.NodeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIndex
implements Index {
    private final HashMap<IndexEntry, IndexEntry> entries = new HashMap();
    private final EndMark pos = new EndMark();
    private boolean readOnly;

    @Override
    public void addOrUpdateEntry(boolean autoCommit, IndexEntry entry) throws IOException {
        TarUtils.check(autoCommit, "Trying to update an entry with autoCommit=false");
        TarUtils.check(!this.readOnly, "Trying to update a read-only index");
        this.pos.add(entry);
        this.entries.put(entry, entry);
    }

    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void close() {
        this.entries.clear();
    }

    @Override
    public void commit() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexEntry> getAllEntries(NodeId after) throws IOException {
        List<IndexEntry> list = new ArrayList<IndexEntry>(this.entries.values());
        Collections.sort(list);
        if (after != null) {
            IndexEntry e;
            IndexEntry search = new IndexEntry(after, 0);
            int start = Collections.binarySearch(list, search);
            int n = start = start >= 0 ? start : -start - 1;
            while (start > 0 && start < list.size() && (e = (IndexEntry)list.get(start)).getUUID().compareTo(after) > 0) {
                --start;
            }
            while (start < list.size() && (e = (IndexEntry)list.get(start)).getUUID().compareTo(after) <= 0) {
                ++start;
            }
            list = list.subList(start, list.size());
        }
        return list.iterator();
    }

    @Override
    public IndexEntry getEntry(NodeId id, int type, boolean returnNext) throws IOException {
        TarUtils.check(!returnNext, "Trying to return the next entry from an in-memory index");
        IndexEntry search = new IndexEntry(id, type);
        return this.get(search);
    }

    IndexEntry get(IndexEntry search) {
        return this.entries.get(search);
    }

    @Override
    public int getToFile() {
        return this.pos.getToFile();
    }

    @Override
    public long getToPos() {
        return this.pos.getToPos();
    }

    @Override
    public void mergeIndex() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public void delete() throws IOException {
        this.entries.clear();
    }

    void clear() {
        this.entries.clear();
    }
}

