/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.file;

import com.day.crx.persistence.tar.file.TarFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TarInputStream
extends InputStream {
    private TarFile tar;
    private long pos;
    private long remaining;
    private long remainingMark;
    private long mark;
    private final byte[] oneBuffer = new byte[1];

    private TarInputStream(TarFile tar, long pos, long remaining) {
        this.tar = tar;
        this.pos = pos;
        this.mark = pos;
        this.remaining = remaining;
        this.remainingMark = remaining;
    }

    public static InputStream getInputStream(TarFile tar, long pos, long length) throws IOException {
        if (tar.getCompressed()) {
            byte[] buffer = new byte[(int)length];
            if (length > Integer.MAX_VALUE) {
                throw new IOException("Large compressed entries not supported");
            }
            tar.readFullyCompressed(buffer, pos, (int)length);
            return new ByteArrayInputStream(buffer);
        }
        return new TarInputStream(tar, pos, length);
    }

    public String toString() {
        return this.tar.toString() + "@" + this.pos;
    }

    public void reset() {
        this.pos = this.mark;
        this.remaining = this.remainingMark;
    }

    public void mark(int readlimit) {
        this.mark = this.pos;
        this.remainingMark = this.remaining;
    }

    public int read() throws IOException {
        int l = this.read(this.oneBuffer, 0, 1);
        if (l < 0) {
            return -1;
        }
        return this.oneBuffer[0] & 0xFF;
    }

    public void close() {
        this.tar = null;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if ((len = (int)Math.min((long)len, this.remaining)) == 0) {
            return -1;
        }
        this.tar.readFully(this.pos, b, off, len);
        this.pos += (long)len;
        this.remaining -= (long)len;
        return len;
    }

    public long skip(long n) {
        n = Math.min(n, this.remaining);
        this.remaining -= n;
        this.pos += n;
        return n;
    }
}

