/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.file;

import com.day.crx.persistence.tar.file.TarFile;
import java.io.IOException;
import java.io.InputStream;

public class FileEntry {
    private final TarFile tar;
    private final String entryName;
    private final long pos;
    private long length;

    public FileEntry(TarFile tar, String entryName, long pos, long length) {
        this.tar = tar;
        this.entryName = entryName;
        this.pos = pos;
        this.length = length;
    }

    public long getPos() {
        return this.pos;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public long getLength() {
        return this.length;
    }

    public InputStream getInputStream() throws IOException {
        return this.tar.getInputStream(this.pos, this.length);
    }

    public void setLength(long length, long time) throws IOException {
        this.tar.updateEntryLength(this.pos, length, time);
        this.length = length;
    }

    public String toString() {
        return this.tar.getFileName() + "/" + this.entryName + "@" + this.pos + "," + this.length;
    }
}

