/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.cluster.ClusterController;
import com.day.crx.core.backup.BackupBarrier;
import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.core.config.CRXClusterConfig;
import com.day.crx.core.journal.Duration;
import com.day.crx.persistence.CRXPMContext;
import com.day.crx.persistence.tar.ClusterTarSet;
import com.day.crx.persistence.tar.OptimizeSchedule;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.PersistenceManagerUtils;
import com.day.crx.persistence.tar.ProcessUtil;
import com.day.crx.persistence.tar.ReplicatingTarSet;
import com.day.crx.persistence.tar.TarJournalPersistence;
import com.day.crx.persistence.tar.TarPersistence;
import com.day.crx.persistence.tar.TarPersistenceStringIndex;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarSetConfig;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarSetStatistics;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.util.RepositoryLockMechanismFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.bundle.AbstractBundlePersistenceManager;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.util.StringIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarPersistenceManager
extends AbstractBundlePersistenceManager
implements TarPersistence {
    private static final long SLEEP_BEFORE_REOPEN = 1000L;
    private static final String SHARED_PATH_WORKSPACES_SUB = "workspaces";
    private static final String DEFAULT_AUTO_OPTIMIZE_AT = "02:00-05:00";
    private static Logger log = LoggerFactory.getLogger(TarPersistenceManager.class);
    private static final byte[] DELETED = new byte[0];
    protected final ErrorHandling errorHandling = new ErrorHandling();
    protected BundleBinding binding;
    protected boolean consistencyCheck;
    protected boolean consistencyFix;
    protected boolean consistencyFixSystem;
    protected String consistencyCheckUUIDs;
    private boolean initialized;
    private TarSetHandler tarset = new TarSet();
    private long currentTransaction = 0L;
    private int lockTimeout;
    private String fileMode = "rw";
    private boolean reopen;
    private String portList;
    private int[] portArray;
    private StringIndex nameIndex;
    private StringIndex nsIndex;
    private int delay;
    private boolean network = true;
    private long lastTransaction;
    private boolean storeNsIndex;
    private boolean needRefresh;
    private String bindAddress;
    private boolean preferredMaster;
    private BackupBarrier barrier;
    private long lastRefresh;
    private String attachScript;
    private int refreshDelay = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.RefreshDelay", -1);
    private final TarSetConfig config;
    private final int delayRead = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.DelayRead", 0);
    private final int delayWrite = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.DelayWrite", 0);
    private FileSystem sharedFs;
    private String repositoryHome;
    private String workspaceName;
    private String workspaceDir;
    private boolean isJournal;

    public TarPersistenceManager() {
        this(new TarSetConfig());
    }

    public TarPersistenceManager(TarSetConfig config) {
        this.config = config;
    }

    protected synchronized void destroy(NodeReferences refs) throws ItemStateException {
        this.append(refs.getTargetId(), 1, DELETED);
    }

    protected synchronized void destroyBundle(NodePropBundle bundle) throws ItemStateException {
        this.append(bundle.getId(), 0, DELETED);
    }

    protected synchronized boolean existsBundle(NodeId id) throws ItemStateException {
        return this.exists(id, 0);
    }

    @Override
    public synchronized NodePropBundle loadBundle(NodeId id) throws ItemStateException {
        return this.loadBundle(id, false);
    }

    public synchronized NodeReferences loadReferencesTo(NodeId targetId) throws NoSuchItemStateException, ItemStateException {
        InputStream in = this.getInputStream(targetId, 1);
        if (in == null) {
            throw new NoSuchItemStateException(targetId.toString());
        }
        return PersistenceManagerUtils.deserializeNodeReferences(targetId, in);
    }

    public NodePropBundle loadBundle(NodeId id, boolean checkBeforeLoading) throws ItemStateException {
        InputStream in = this.getInputStream(id, 0);
        if (in == null) {
            return null;
        }
        if (checkBeforeLoading) {
            PersistenceManagerUtils.checkBundle(this.binding, in);
            return this.loadBundle(id, false);
        }
        return PersistenceManagerUtils.deserializeBundle(this.binding, id, in);
    }

    protected synchronized void store(NodeReferences refs) throws ItemStateException {
        byte[] data = this.serializeNodeReferences(refs);
        this.append(refs.getTargetId(), 1, data);
    }

    @Override
    public synchronized void storeBundle(NodePropBundle bundle) throws ItemStateException {
        byte[] data = PersistenceManagerUtils.serializeBundle(this.binding, bundle);
        this.append(bundle.getId(), 0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws Exception {
        try {
            this.waitForBackup();
            this.tarset.sync(true);
            this.tarset.close();
            this.initialized = false;
            if (this.barrier != null) {
                this.barrier.close();
                this.barrier = null;
            }
            Object var2_1 = null;
            TarJournalPersistence persistence = this.getPersistence();
            persistence.removeWorkspace(this.workspaceName);
            persistence.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            TarJournalPersistence persistence = this.getPersistence();
            persistence.removeWorkspace(this.workspaceName);
            persistence.close();
            throw throwable;
        }
    }

    private TarJournalPersistence getPersistence() {
        return TarJournalPersistence.getInstance(this.repositoryHome);
    }

    public synchronized boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        return this.exists(targetId, 1);
    }

    private void applyClusterConfig(PMContext c) throws RepositoryException {
        CRXClusterConfig clusterConfig;
        if (!(c instanceof CRXPMContext)) {
            return;
        }
        CRXPMContext context = (CRXPMContext)c;
        String localPath = context.getHomeDir().getAbsolutePath();
        int nameIdx = localPath.lastIndexOf(File.separatorChar);
        if (nameIdx == -1) {
            nameIdx = 0;
        }
        String name = localPath.substring(nameIdx + 1);
        String sharedPath = context.getSharedPath();
        if (sharedPath == null || !this.getCluster()) {
            // empty if block
        }
        if ((clusterConfig = context.getCRXClusterConfig()) != null) {
            this.network = true;
            this.setCluster(true);
            if (context.isWorkspace()) {
                sharedPath = sharedPath + File.separatorChar + SHARED_PATH_WORKSPACES_SUB;
            }
            if (context.isPreferredMaster()) {
                this.preferredMaster = true;
            }
            this.setSharedPath(sharedPath + File.separatorChar + name);
            FileSystemFactory fsf = clusterConfig.getClusterFileSystemFactory();
            if (fsf != null) {
                this.sharedFs = fsf.getFileSystem();
                String s = this.config.getSharedPath();
                if (s.startsWith(sharedPath)) {
                    s = s.substring(sharedPath.length());
                }
                this.sharedFs = new BasedFileSystem(this.sharedFs, s + "/control");
            }
            boolean outOfSyncRecoveryEnabled = clusterConfig.isOutOfSyncRecoveryEnabled();
            this.config.setOutOfSyncRecoveryEnabled(outOfSyncRecoveryEnabled);
        }
    }

    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.barrier = new BackupBarrier();
        this.applyClusterConfig(context);
        super.init(context);
        this.repositoryHome = context.getHomeDir().getParentFile().getCanonicalPath();
        if (!(context instanceof CRXPMContext)) {
            throw new RepositoryException("CRXPMContext required");
        }
        CRXPMContext ctx = (CRXPMContext)context;
        if (ctx.isWorkspace()) {
            this.repositoryHome = new File(this.repositoryHome + "/..").getCanonicalPath();
        }
        TarJournalPersistence persistence = TarJournalPersistence.getInstance(this.repositoryHome);
        persistence.setCRXPMContext(ctx);
        String path = context.getHomeDir().getAbsolutePath();
        this.workspaceName = context.getHomeDir().getName();
        this.workspaceDir = path;
        persistence.addWorkspace(this.workspaceName, this);
        RepositoryLockMechanismFactory.createInstance(this.getLockClass());
        if (ctx.isSharedNothing()) {
            this.config.setSharedNothing(true);
        }
        if (this.config.getSharedPath() == null) {
            this.config.setSharedPath(path);
        }
        if (this.config.getLocalPath() == null) {
            this.config.setLocalPath(path);
        }
        if (this.getAutoOptimizeAt() == null) {
            this.setAutoOptimizeAt(DEFAULT_AUTO_OPTIMIZE_AT);
        }
        try {
            this.openTarSet(false);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        this.binding = new BundleBinding(this.errorHandling, null, this.getNsIndex(), this.getNameIndex(), context.getDataStore());
        this.binding.setMinBlobSize(Integer.MAX_VALUE);
        this.initTarSetStatistics();
        this.initialized = true;
        PersistenceManagerUtils.checkFixConsistency(this, this.workspaceDir, this.consistencyCheck, this.consistencyFix, this.consistencyCheckUUIDs);
    }

    private void initTarSetStatistics() {
        if ("tarJournal".equals(this.workspaceName) || "version".equals(this.workspaceName)) {
            return;
        }
        this.tarset.setTarSetStatistics(new TarSetStatistics(this.tarset, this.workspaceName, this.context.getRepositoryStatistics()));
    }

    public synchronized void store(final ChangeLog changeLog) throws ItemStateException {
        this.storeTransaction(new Transaction(){

            public void store() throws ItemStateException {
                TarPersistenceManager.super.store(changeLog);
            }
        });
    }

    protected synchronized void storeTransaction(Transaction t) throws ItemStateException {
        Throwable lastException = null;
        this.refresh();
        for (int i = 0; i < 3; ++i) {
            try {
                this.tryStore(t);
                return;
            }
            catch (NoSuchItemStateException e) {
                lastException = e;
                break;
            }
            catch (ItemStateException e) {
                this.reopenTarSetQuickly();
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    /*
     * Loose catch block
     */
    private void tryStore(Transaction t) throws ItemStateException {
        block10: {
            this.waitForBackup();
            try {
                this.tarset.lockShared();
            }
            catch (IOException e) {
                String msg = "Could not lock";
                log.warn(msg + ": " + e.toString());
                log.debug(msg, (Throwable)e);
                throw new ItemStateException(msg, (Throwable)e);
            }
            boolean stored = false;
            LowDiskSpaceMonitor.getInstance().checkDiskSpace();
            this.currentTransaction = this.getNextTransaction();
            this.tarset.startTransaction(this.currentTransaction);
            t.store();
            this.tarset.appendCommit(this.currentTransaction);
            stored = true;
            Object var6_6 = null;
            if (stored) break block10;
            try {
                this.tarset.appendRollback(this.currentTransaction);
                break block10;
            }
            catch (IOException e2) {
                log.error("Failed to rollback transaction " + this.currentTransaction, (Throwable)e2);
            }
            {
                break block10;
                catch (IOException e) {
                    String msg = "Failed to store change log; transaction " + this.currentTransaction;
                    log.warn(msg + ": " + e.toString());
                    log.debug(msg, (Throwable)e);
                    throw new ItemStateException(msg, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (!stored) {
                    try {
                        this.tarset.appendRollback(this.currentTransaction);
                    }
                    catch (IOException e2) {
                        log.error("Failed to rollback transaction " + this.currentTransaction, (Throwable)e2);
                    }
                }
                this.currentTransaction = 0L;
                this.tarset.unlockShared();
                throw throwable;
            }
        }
        this.currentTransaction = 0L;
        this.tarset.unlockShared();
    }

    public boolean getOptimizeWhenIdle() {
        return this.tarset.getOptimizeWhenIdle();
    }

    public void setOptimizeWhenIdle(boolean optimizeWhenIdle) {
    }

    public boolean getCompressFiles() {
        return this.tarset.getCompressFiles();
    }

    public void setCompressFiles(boolean compressFiles) {
        this.tarset.setCompressFiles(compressFiles);
    }

    public String getMaxFileSize() {
        return Integer.toString(this.tarset.getMaxFileSize());
    }

    public void setMaxFileSize(String maxFileSize) {
        if (maxFileSize != null) {
            int x = TarUtils.parseIntSetting(maxFileSize, 1, 1024);
            this.tarset.setMaxFileSize(x);
        }
    }

    public String getIndexMemoryBufferSize() {
        return Integer.toString(this.config.getIndexMemoryBufferSize());
    }

    public void setIndexMemoryBufferSize(String indexMemoryBufferSize) {
        this.config.setIndexMemoryBufferSize(Integer.decode(indexMemoryBufferSize));
    }

    public String getIndexCacheSize() {
        return Integer.toString(this.config.getIndexCacheSize());
    }

    public void setIndexCacheSize(String indexCacheSize) {
        this.config.setIndexCacheSize(Integer.decode(indexCacheSize));
    }

    public String getIndexMaxFileEntrySize() {
        return Integer.toString(this.config.getIndexMaxFileEntrySize());
    }

    public void setIndexMaxFileEntrySize(String indexMaxFileEntrySize) {
        this.config.setIndexMaxFileEntrySize(Integer.decode(indexMaxFileEntrySize));
    }

    public String getIndexMaxBuffer() {
        return Integer.toString(this.config.getIndexMaxBuffer());
    }

    public void setIndexMaxBuffer(String maxIndexBuffer) {
        this.config.setIndexMaxBuffer(Integer.decode(maxIndexBuffer));
    }

    public int getOptimizeCount() {
        return this.tarset.getOptimizeCount();
    }

    public void setOptimizeCount(int optimizeCount) {
        this.tarset.setOptimizeCount(optimizeCount);
    }

    public synchronized List<NodeId> getAllNodeIds(NodeId after, int maxCount) throws ItemStateException {
        try {
            this.refresh();
            Iterator<IndexEntry> it = this.tarset.getIndex().getAllEntries(after);
            final FilterNodeIdIterator filtered = new FilterNodeIdIterator(it, after, maxCount);
            if (!filtered.hasNext()) {
                return Collections.emptyList();
            }
            return new List<NodeId>(){

                @Override
                public Iterator<NodeId> iterator() {
                    return filtered;
                }

                @Override
                public int size() {
                    return -1;
                }

                @Override
                public boolean add(NodeId e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(int index, NodeId element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(Collection<? extends NodeId> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean addAll(int index, Collection<? extends NodeId> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean contains(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean containsAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NodeId get(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int indexOf(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public int lastIndexOf(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ListIterator<NodeId> listIterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public ListIterator<NodeId> listIterator(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean remove(Object o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NodeId remove(int index) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public NodeId set(int index, NodeId element) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<NodeId> subList(int fromIndex, int toIndex) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Object[] toArray() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public <T> T[] toArray(T[] a) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException e) {
            String msg = "Failed to get iterator for node: " + after + ": " + e;
            log.error(msg);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    @Override
    public synchronized void refresh() {
        block8: {
            this.tarset.touch();
            if (!this.needRefresh) {
                return;
            }
            this.needRefresh = false;
            try {
                if (this.network) {
                    this.tarset.readExternalChanges();
                    return;
                }
                if (this.reopen) {
                    this.tarset.close();
                    if (this.delay > 0) {
                        try {
                            Thread.sleep(this.delay);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    this.openTarSet(true);
                    this.tarset.setFailOnError(false);
                    break block8;
                }
                this.tarset.readExternalChanges();
            }
            catch (IOException e) {
                this.reopenTarSet();
            }
        }
    }

    public synchronized void onExternalUpdate(ChangeLog changes) {
        super.onExternalUpdate(changes);
        if (log.isDebugEnabled()) {
            log.debug("onExternalUpdate " + this.config.getLocalPath() + " " + this.needRefresh);
        }
        if (!this.needRefresh) {
            long now = System.currentTimeMillis();
            if (this.lastRefresh == 0L || now > this.lastRefresh + (long)this.refreshDelay) {
                this.needRefresh = true;
                this.lastRefresh = now;
            }
        }
    }

    private void reopenTarSetQuickly() throws ItemStateException {
        try {
            log.debug("Re-opening tar set");
            this.tarset.close();
            this.openTarSet(true);
            log.debug("Re-opening done");
        }
        catch (Throwable e2) {
            log.error("Error re-opening the tar set", e2);
            throw new ItemStateException("Could not open tar set", e2);
        }
    }

    synchronized void reopenTarSet() {
        try {
            this.tarset.close();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            this.openTarSet(true);
        }
        catch (IOException e1) {
            log.error("Error re-opening tarset", (Throwable)e1);
            this.tarset = null;
        }
    }

    private void openTarSet(boolean failOnError) throws IOException {
        TarSetHandler newInstance;
        this.waitForBackup();
        if (this.config.isCluster() && this.network) {
            if (this.config.isSharedNothing()) {
                ClusterTarSet set = new ClusterTarSet(this.repositoryHome, this.workspaceName, this.isJournal);
                newInstance = set;
            } else {
                ReplicatingTarSet set = new ReplicatingTarSet(this);
                set.setBindAddress(this.bindAddress);
                set.setPortArray(this.portArray);
                set.setPreferredMaster(this.preferredMaster);
                newInstance = set;
            }
        } else {
            newInstance = new TarSet();
        }
        newInstance.setCompressFiles(this.tarset.getCompressFiles());
        newInstance.setOptimizeWhenIdle(this.tarset.getOptimizeWhenIdle());
        newInstance.setLogEverything(this.tarset.getLogEverything());
        newInstance.setMaxFileSize(this.tarset.getMaxFileSize());
        newInstance.setOptimizeCount(this.tarset.getOptimizeCount());
        newInstance.setOptimizeSleep(this.tarset.getOptimizeSleep());
        newInstance.setLockClass(this.tarset.getLockClass());
        newInstance.setFailOnError(failOnError);
        newInstance.setMergeIndexWhenClosing(this.tarset.getMergeIndexWhenClosing());
        newInstance.setConfig(this.config);
        newInstance.setTarSetStatistics(new TarSetStatistics(newInstance, this.workspaceName, this.context.getRepositoryStatistics()));
        newInstance.open(this.config.getSharedPath(), this.config.getLocalPath(), this.config.isCluster(), this.lockTimeout, this.fileMode);
        this.tarset = newInstance;
    }

    public String getLocalPath() {
        return this.config.getLocalPath();
    }

    public void setLocalPath(String localPath) {
        this.config.setLocalPath(localPath);
    }

    public String getSharedPath() {
        return this.config.getSharedPath();
    }

    public void setSharedPath(String sharedPath) {
        this.config.setSharedPath(sharedPath);
    }

    public void setFileMode(String fileMode) {
        this.fileMode = fileMode;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public boolean getCluster() {
        return this.config.isCluster();
    }

    public void setCluster(boolean cluster) {
        this.config.setCluster(cluster);
    }

    public boolean getConsistencyCheck() {
        return this.consistencyCheck;
    }

    public void setConsistencyCheck(boolean consistencyCheck) {
        this.consistencyCheck = consistencyCheck;
    }

    public boolean getConsistencyFix() {
        return this.consistencyFix;
    }

    public void setConsistencyFix(boolean consistencyFix) {
        this.consistencyFix = consistencyFix;
    }

    public boolean getConsistencyFixSystem() {
        return this.consistencyFixSystem;
    }

    public void setConsistencyFixSystem(boolean consistencyFixSystem) {
        this.consistencyFixSystem = consistencyFixSystem;
    }

    public boolean getLogEverything() {
        return this.tarset.getLogEverything();
    }

    public void setLogEverything(boolean logEverything) {
        this.tarset.setLogEverything(logEverything);
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public String getOptimizeSleep() {
        return String.valueOf(this.tarset.getOptimizeSleep());
    }

    public void setOptimizeSleep(String value) {
        this.tarset.setOptimizeSleep(Double.parseDouble(value));
    }

    public StringIndex getNameIndex() {
        this.nameIndex = TarPersistenceStringIndex.getIndex(this, this.context.getFileSystem(), "/names.properties", TarPersistenceStringIndex.MAGIC_NAME_INDEX_ID, this.nameIndex);
        if (this.nameIndex == null) {
            this.nameIndex = super.getNameIndex();
        }
        return this.nameIndex;
    }

    public StringIndex getNsIndex() {
        if (this.storeNsIndex) {
            this.nsIndex = TarPersistenceStringIndex.getIndex(this, this.context.getFileSystem(), "/namespaces.properties", TarPersistenceStringIndex.MAGIC_NS_INDEX_ID, this.nsIndex);
            if (this.nsIndex == null) {
                this.nsIndex = super.getNsIndex();
            }
            return this.nsIndex;
        }
        return super.getNsIndex();
    }

    public void setReopen(boolean reopen) {
        this.reopen = reopen;
    }

    public boolean getReopen() {
        return this.reopen;
    }

    public void setStoreNsIndex(boolean storeNsIndex) {
        this.storeNsIndex = storeNsIndex;
    }

    public boolean getStoreNsIndex() {
        return this.storeNsIndex;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean getNetwork() {
        return this.network;
    }

    public void setNetwork(boolean network) {
        this.network = network;
    }

    private long getNextTransaction() {
        TarJournalPersistence p;
        if (TarJournalPersistence.JOURNAL_TRANSACTIONS && (p = this.getPersistence()) != null) {
            long tx;
            long old = Math.max(this.lastTransaction, this.tarset.getLastTransaction());
            this.lastTransaction = tx = p.getCurrentTransaction(old);
            return tx;
        }
        long tx = System.currentTimeMillis();
        if (tx <= this.lastTransaction) {
            tx = this.lastTransaction + 1L;
        }
        this.lastTransaction = tx = Math.max(tx, this.tarset.getLastTransaction() + 1L);
        return tx;
    }

    @Override
    public BundleBinding getBinding() {
        return this.binding;
    }

    @Deprecated
    protected BLOBStore getBlobStore() {
        return null;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public TarSetHandler getTarSet() {
        return this.tarset;
    }

    @Override
    public void lockExclusive() throws IOException {
        this.tarset.lockShared();
    }

    @Override
    public void unlockExclusive() {
        this.tarset.unlockShared();
    }

    @Override
    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
        int total = this.getNodeCountEstimate();
        PersistenceManagerUtils.checkConsistency(this, total, uuids, recursive, fix, this.consistencyFixSystem);
    }

    protected int getNodeCountEstimate() {
        try {
            return this.tarset.getIndex().size();
        }
        catch (IOException e) {
            log.warn("Could not get the item count", (Throwable)e);
            return 0;
        }
    }

    @Override
    public void evictBundle(NodeId id) {
        super.evictBundle(id);
    }

    public String getPortList() {
        return this.portList;
    }

    public void setPortList(String portList) {
        this.portList = portList;
        this.portArray = ClusterController.parsePortList(portList);
    }

    public void setLockClass(String lockClass) {
        this.tarset.setLockClass(lockClass);
    }

    public String getLockClass() {
        return this.tarset.getLockClass();
    }

    public void setLockClassMaster(String lockClassMaster) {
        this.config.setLockClassMaster(lockClassMaster);
    }

    public String getLockClassMaster() {
        return this.config.getLockClassMaster();
    }

    public String getConsistencyCheckUUIDs() {
        return this.consistencyCheckUUIDs;
    }

    public void setConsistencyCheckUUIDs(String consistencyCheckUUIDs) {
        this.consistencyCheckUUIDs = consistencyCheckUUIDs;
    }

    public void setPreferredMaster(boolean preferredMaster) {
        this.preferredMaster = preferredMaster;
    }

    public boolean isPreferredMaster() {
        return this.preferredMaster;
    }

    public int getMergeIndexWhenClosing() {
        return this.tarset.getMergeIndexWhenClosing();
    }

    public void setMergeIndexWhenClosing(int mergeIndexWhenClosing) {
        this.tarset.setMergeIndexWhenClosing(mergeIndexWhenClosing);
    }

    public String getAutoOptimizeAt() {
        return this.config.getSchedule().toString();
    }

    public void setAutoOptimizeAt(String autoOptimizeAt) {
        OptimizeSchedule schedule = OptimizeSchedule.getInstance(autoOptimizeAt);
        this.config.setSchedule(schedule);
    }

    public int getCacheFiles() {
        return this.config.getCacheFiles();
    }

    public void setCacheFiles(int cacheFiles) {
        this.config.setCacheFiles(cacheFiles);
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    public void setGenerationalGC(boolean generationalGC) {
        this.config.setGenerationalGC(generationalGC);
    }

    public boolean isGenerationalGC() {
        return this.config.isGenerationalGC();
    }

    public boolean isIndexInMemory() {
        return this.config.isIndexInMemory();
    }

    public void setIndexInMemory(boolean indexInMemory) {
        this.config.setIndexInMemory(indexInMemory);
    }

    private void delay(int ms) {
        if (ms > 0) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized IndexEntry append(NodeId id, int indexEntryType, byte[] data) throws ItemStateException {
        this.checkInitialized();
        this.waitForBackup();
        try {
            this.delay(this.delayWrite);
            this.refresh();
            return this.tarset.append(id, indexEntryType, data);
        }
        catch (Exception e) {
            String msg = "Failed to append bundle: " + id + " len: " + data.length + ": " + e;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    protected synchronized boolean exists(NodeId id, int indexEntryType) throws ItemStateException {
        this.checkInitialized();
        try {
            this.delay(this.delayRead);
            this.refresh();
            return this.tarset.exists(id, indexEntryType);
        }
        catch (Exception e) {
            String msg = "Failed to check bundle: " + id + ": " + e;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    protected synchronized IndexEntry getIndexEntry(NodeId id, int indexEntryType) throws IOException {
        return this.tarset.getIndexEntry(id, 1);
    }

    @Override
    public synchronized InputStream getInputStream(NodeId id, int indexEntryType) throws NoSuchItemStateException, ItemStateException {
        this.checkInitialized();
        this.delay(this.delayRead);
        this.refresh();
        try {
            return this.tarset.getInputStream(id, indexEntryType);
        }
        catch (Exception e) {
            String msg = "Failed to read bundle: " + id + ": " + e;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    protected byte[] serializeNodeReferences(NodeReferences refs) throws ItemStateException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Serializer.serialize((NodeReferences)refs, (OutputStream)out);
            out.flush();
            return out.toByteArray();
        }
        catch (Exception e) {
            String msg = "Failed to store bundle: " + refs + ": " + e;
            log.error(msg, (Throwable)e);
            throw new ItemStateException(msg, (Throwable)e);
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    FileSystem getSharedFileSystem() {
        return this.sharedFs;
    }

    public boolean isMaster() {
        return this.tarset.isMaster();
    }

    public String getAttachScript() {
        return this.attachScript;
    }

    public void setAttachScript(String attachScript) {
        this.attachScript = attachScript;
    }

    public boolean attachSharedStorage() {
        if (this.attachScript == null) {
            return true;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.attachScript, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        String result = ProcessUtil.runProcess(list);
        if (result.length() == 0) {
            return true;
        }
        log.warn("Attaching shared storage failed: " + result);
        return false;
    }

    public String toString() {
        return super.toString() + " " + this.config.getLocalPath();
    }

    @Override
    public String getWorkspaceDir() {
        return this.workspaceDir;
    }

    public void setMaximumAge(Duration maximumAge) {
        this.config.setMaximumAge(maximumAge);
    }

    @Override
    public void waitForBackup() {
        if (this.barrier != null) {
            this.barrier.waitForBackup();
        }
    }

    public void setJournal(boolean isJournal) {
        this.isJournal = isJournal;
        this.config.setJournal(isJournal);
    }

    public void setOutOfSyncRecoveryEnabled(boolean value) {
        this.config.setOutOfSyncRecoveryEnabled(value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterNodeIdIterator
    implements Iterator<NodeId> {
        private final Iterator<IndexEntry> it;
        private final int maxCount;
        private NodeId current;
        private int pos;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FilterNodeIdIterator(Iterator<IndexEntry> it, NodeId bigger, int maxCount) {
            this.it = it;
            this.maxCount = maxCount;
            while (true) {
                if (!it.hasNext()) {
                    this.current = null;
                    return;
                }
                IndexEntry entry = it.next();
                if (entry == null) return;
                if (this.canSkip(entry)) continue;
                this.current = entry.getUUID();
                if (bigger == null || bigger.compareTo(this.current) < 0) return;
            }
        }

        private boolean canSkip(IndexEntry entry) {
            if (entry.getLength() == 0L) {
                return true;
            }
            if (entry.getType() != 0) {
                return true;
            }
            NodeId id = entry.getUUID();
            return TarPersistenceStringIndex.MAGIC_NAME_INDEX_ID.equals((Object)id) || TarPersistenceStringIndex.MAGIC_NS_INDEX_ID.equals((Object)id);
        }

        private NodeId readNext() {
            IndexEntry entry;
            if (this.maxCount != 0 && this.pos++ > this.maxCount || !this.it.hasNext()) {
                return null;
            }
            do {
                if ((entry = this.it.next()) != null) continue;
                return null;
            } while (this.canSkip(entry));
            return entry.getUUID();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public NodeId next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            NodeId result = this.current;
            this.current = this.readNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static interface Transaction {
        public void store() throws ItemStateException;
    }
}

