/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.core.journal.Duration;
import com.day.crx.persistence.CRXPMContext;
import com.day.crx.persistence.tar.ReentrantLockWithInfo;
import com.day.crx.persistence.tar.TarJournal;
import com.day.crx.persistence.tar.TarPersistenceManager;
import com.day.crx.persistence.tar.TarSetHandler;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.core.journal.JournalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarJournalPersistence {
    public static final boolean JOURNAL_TRANSACTIONS = Boolean.valueOf(System.getProperty("com.day.crx.persistence.tar.JournalTransactions", "true"));
    public static final int DELAY_WRITE_MAX_SECONDS = Integer.getInteger("com.day.crx.persistence.tar.DelayWritesMax", 15);
    public static final int DELAY_JOURNAL_CLOSE_MAX_SECONDS = Integer.getInteger("com.day.crx.persistence.tar.DelayJournalCloseMax", 15);
    protected static final Logger LOG = LoggerFactory.getLogger(TarJournalPersistence.class);
    protected static final Map<String, TarJournalPersistence> INSTANCE_MAP = new HashMap<String, TarJournalPersistence>();
    String repositoryHome;
    TarJournal journal;
    private TarPersistenceManager tar;
    private final Map<String, TarPersistenceManager> workspaces = Collections.synchronizedMap(new HashMap());
    private ReentrantLockWithInfo lock = new ReentrantLockWithInfo();
    private Duration maximumAge;
    private CRXPMContext context;
    private long lastTransaction;
    private long currentTransaction;
    final AtomicInteger writeDelay = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TarJournalPersistence getInstance(String repositoryHome) {
        Map<String, TarJournalPersistence> map = INSTANCE_MAP;
        synchronized (map) {
            TarJournalPersistence p = INSTANCE_MAP.get(repositoryHome);
            if (p == null) {
                p = new TarJournalPersistence();
                p.repositoryHome = repositoryHome;
                INSTANCE_MAP.put(repositoryHome, p);
            }
            return p;
        }
    }

    void setTar(TarPersistenceManager tar) {
        this.tar = tar;
    }

    TarPersistenceManager getTar() {
        return this.tar;
    }

    void lock() throws JournalException {
        try {
            this.lock.lock();
        }
        catch (InterruptedException e) {
            throw new JournalException("Lock failed", (Throwable)e);
        }
    }

    void unlock() {
        this.lock.unlock();
    }

    void unlockForce() {
        this.lock.unlockForce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        boolean needToClose;
        Map<String, TarJournalPersistence> map = INSTANCE_MAP;
        synchronized (map) {
            needToClose = this.journal == null;
            if (needToClose &= this.workspaces.size() == 0) {
                INSTANCE_MAP.remove(this.repositoryHome);
            }
        }
        if (needToClose && this.tar != null) {
            try {
                this.tar.close();
            }
            catch (Exception e) {
                LOG.error("Error closing", (Throwable)e);
            }
        }
    }

    public void setMaximumAge(Duration maximumAge) {
        this.maximumAge = maximumAge;
    }

    public Duration getMaximumAge() {
        return this.maximumAge;
    }

    public void setCRXPMContext(CRXPMContext context) {
        this.context = context;
    }

    public CRXPMContext getCRXPMContext() {
        return this.context;
    }

    public void addWorkspace(String workspaceName, TarPersistenceManager pm) {
        this.workspaces.put(workspaceName, pm);
    }

    public void removeWorkspace(String workspaceName) {
        this.workspaces.remove(workspaceName);
    }

    public TarPersistenceManager getWorkspace(String workspaceName) {
        return this.workspaces.get(workspaceName);
    }

    public long getCurrentTransaction(long old) {
        long tx = this.currentTransaction;
        if (tx == 0L) {
            tx = System.currentTimeMillis();
            tx = Math.max(tx, this.lastTransaction + 1L);
        }
        this.currentTransaction = tx = Math.max(tx, old + 1L);
        return tx;
    }

    public void endTransaction() {
        this.lastTransaction = this.currentTransaction;
        this.currentTransaction = 0L;
    }

    public void rollbackWorkspaces(long transaction) throws IOException {
        for (Map.Entry<String, TarPersistenceManager> e : this.workspaces.entrySet()) {
            String w = e.getKey();
            TarPersistenceManager pm = e.getValue();
            TarJournalPersistence.rollback(w, pm.getTarSet(), transaction);
        }
    }

    public void rollbackJournal(long transaction) throws IOException, JournalException {
        if (this.journal == null) {
            LOG.warn("TarJournal is not used, rollback to transaction ignored");
            return;
        }
        TarJournalPersistence.rollback("tarJournal", this.journal.getTar().getTarSet(), transaction);
    }

    private static void rollback(String name, TarSetHandler set, long transaction) throws IOException {
        LOG.info("Rollback to transaction " + transaction + ": " + name);
        long[] filePos = set.findTransactionStart(transaction, false);
        if (filePos != null) {
            LOG.info("Truncating to file " + filePos[0] + " pos " + filePos[1] + " for " + set.getLocalPath());
            set.truncate((int)filePos[0], filePos[1]);
        }
    }

    public long getRevisionForTransaction(long transaction) throws IOException, JournalException {
        long[] filePos = this.journal.getTar().getTarSet().findTransactionStart(transaction, true);
        if (filePos == null) {
            return -1L;
        }
        return TarJournal.getRevision((int)filePos[0], filePos[1]);
    }

    public void delayWritesBegin(Object logObject) {
        LOG.info("Delay writes begin for " + logObject);
        this.writeDelay.incrementAndGet();
    }

    public void delayWritesEnd(final Object logObject) {
        final String msg = "Delay writes end for " + logObject;
        LOG.info(msg);
        Thread t = new Thread(msg){

            public void run() {
                for (int i = 0; i < DELAY_WRITE_MAX_SECONDS; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    TarJournal j = TarJournalPersistence.this.journal;
                    if (j == null || !j.isMaster()) continue;
                    LOG.info("Write delay stopped as journal is master: " + logObject);
                    break;
                }
                int x = TarJournalPersistence.this.writeDelay.decrementAndGet();
                LOG.info(msg + ", counter=" + x);
                if (x < 0) {
                    LOG.info("Write delay counter is below 0, fixing: " + x + ": " + logObject);
                    TarJournalPersistence.this.writeDelay.set(0);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public void delayWritesIfNecessary(Object logObject) throws IOException {
        if (this.writeDelay.get() == 0) {
            return;
        }
        LOG.info("Delay writes for " + logObject);
        for (int i = 0; i < DELAY_WRITE_MAX_SECONDS; ++i) {
            if (this.writeDelay.get() == 0) {
                LOG.info("Continue writes " + logObject);
                return;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOG.warn("Break the write delay after " + DELAY_WRITE_MAX_SECONDS + " seconds: " + logObject);
        this.writeDelay.set(0);
        throw new IOException("Write barrier broken");
    }
}

