/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.core.journal.Duration;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.ReplicatingTarSet;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.jackrabbit.core.id.NodeId;
import org.slf4j.Logger;

class ReplicationProcessor
extends Thread {
    private static final int OP_LOCK = 1;
    private static final int OP_UNLOCK = 2;
    private static final int OP_OK = 3;
    private static final int OP_WRITE = 4;
    private static final int OP_APPEND = 5;
    private static final int OP_APPEND_COMMIT = 6;
    private static final int OP_APPEND_ROLLBACK = 7;
    private static final int OP_LAST_TRANSACTION = 8;
    private static final int OP_CONNECT = 9;
    private static final int OP_CLOSE = 10;
    private static final int OP_FIRST = 11;
    private static final byte OP_STOP_MASTER = 12;
    private static final byte OP_ABORT = 13;
    private static final byte OP_VERIFY = 14;
    private static final byte OP_VERIFY_DATA = 15;
    private final ReplicatingTarSet server;
    private final ReplicatingTarSet.ReplicationListener listener;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private final byte[] buffer = new byte[4096];
    private boolean stop;

    ReplicationProcessor(ReplicatingTarSet server, Socket socket, ReplicatingTarSet.ReplicationListener listener) throws IOException {
        this.server = server;
        this.socket = socket;
        this.listener = listener;
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    void stopNow() {
        if (this.stop) {
            return;
        }
        if (this.listener != null) {
            try {
                this.out.write(10);
                this.out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.stop = true;
        TarUtils.closeSilently(this.in);
        this.in = null;
        TarUtils.closeSilently(this.out);
        this.out = null;
        this.socket = TarUtils.closeSilently(this.socket);
    }

    private void debug(String s) {
        this.server.debug(s);
    }

    void connect(String key) throws IOException {
        this.debug("send OP_CONNECT");
        this.out.write(9);
        this.out.writeUTF(key);
        this.out.flush();
        if (this.in.read() == 3) {
            return;
        }
        throw new IOException("Connection failed, may be wrong protocol");
    }

    void appendCommit(long tx) throws IOException {
        this.debug("send OP_APPEND_COMMIT");
        this.out.write(6);
        this.out.writeLong(tx);
        this.out.flush();
        int op = this.in.read();
        if (op == 3) {
            this.debug("  OP_OK");
            return;
        }
        throw new IOException("Unexpected response: " + op);
    }

    private void processAppendCommit() throws IOException {
        this.debug("process AppendCommit");
        long tx = this.in.readLong();
        this.server.appendCommit(tx);
        this.out.write(3);
        this.debug("  send OP_OK");
        this.out.flush();
    }

    void appendRollback(long tx) throws IOException {
        this.debug("send OP_APPEND_ROLLBACK");
        this.out.write(7);
        this.out.writeLong(tx);
        this.out.flush();
        int op = this.in.read();
        if (op == 3) {
            this.debug("  OP_OK");
            return;
        }
        throw new IOException("Unexpected response: " + op);
    }

    private void processStopMaster() throws IOException {
        this.debug("  OP_STOP_MASTER");
        this.server.lockShared();
        if (this.server.isPreferredMaster()) {
            ReplicatingTarSet.log.warn("Multiple preferred masters configured?");
            this.debug("  send OP_STOP_MASTER");
            this.out.write(12);
        } else {
            this.debug("  send OP_OK");
            this.out.write(3);
        }
        this.server.close();
        this.server.reopen();
    }

    private void processAppendRollback() throws IOException {
        this.debug("process AppendRollback");
        long tx = this.in.readLong();
        this.server.appendRollback(tx);
        this.out.write(3);
        this.debug("  send OP_OK");
        this.out.flush();
    }

    void append(long tx, NodeId id, int type, byte[] data, long time) throws IOException {
        this.debug("send OP_APPEND");
        this.out.write(5);
        this.out.writeLong(tx);
        this.out.writeUTF(id.toString());
        this.out.writeInt(type);
        this.out.writeLong(time);
        this.out.writeLong(data.length);
        this.out.write(data);
        this.out.flush();
    }

    private long processAppend() throws IOException {
        this.debug("process Append");
        long tx = this.in.readLong();
        String uuid = this.in.readUTF();
        int type = this.in.readInt();
        long time = this.in.readLong();
        long length = this.in.readLong();
        byte[] data = new byte[(int)length];
        this.in.readFully(data);
        this.server.setTransaction(tx);
        this.server.append(new NodeId(uuid), type, data, time);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean needToUnlock = false;
        try {
            try {
                this.debug("waiting for OP_CONNECT");
                int op = this.in.read();
                if (op != 9) {
                    throw new IOException("Unexpected connect operation: " + op);
                }
                String key = this.in.readUTF();
                this.server.checkKey(key);
                this.debug("connected");
                this.out.write(3);
                this.out.flush();
                block15: while (!this.stop) {
                    op = this.in.read();
                    if (this.stop) break;
                    switch (op) {
                        case 14: {
                            this.processVerify();
                            continue block15;
                        }
                        case 1: {
                            needToUnlock = true;
                            this.processLock();
                            continue block15;
                        }
                        case 2: {
                            this.processUnlock();
                            needToUnlock = false;
                            continue block15;
                        }
                        case 5: {
                            this.processAppend();
                            continue block15;
                        }
                        case 6: {
                            this.processAppendCommit();
                            continue block15;
                        }
                        case 7: {
                            this.processAppendRollback();
                            continue block15;
                        }
                        case 12: {
                            this.processStopMaster();
                            continue block15;
                        }
                        case -1: 
                        case 10: {
                            this.stop = true;
                            continue block15;
                        }
                    }
                    throw new IOException("unexpected operation: " + op);
                }
                Object var5_6 = null;
                if (needToUnlock) {
                    this.processUnlock();
                }
            }
            catch (IOException e) {
                ReplicatingTarSet.log.warn("IOException: " + e);
                Object var5_7 = null;
                if (needToUnlock) {
                    this.processUnlock();
                }
                TarUtils.closeSilently(this.in);
                TarUtils.closeSilently(this.out);
                TarUtils.closeSilently(this.socket);
                this.listener.removeProcessor(this);
                return;
            }
            catch (Throwable e) {
                ReplicatingTarSet.log.error("Exception: " + e, e);
                Object var5_8 = null;
                if (needToUnlock) {
                    this.processUnlock();
                }
                TarUtils.closeSilently(this.in);
                TarUtils.closeSilently(this.out);
                TarUtils.closeSilently(this.socket);
                this.listener.removeProcessor(this);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (needToUnlock) {
                this.processUnlock();
            }
            TarUtils.closeSilently(this.in);
            TarUtils.closeSilently(this.out);
            TarUtils.closeSilently(this.socket);
            this.listener.removeProcessor(this);
            throw throwable;
        }
        TarUtils.closeSilently(this.in);
        TarUtils.closeSilently(this.out);
        TarUtils.closeSilently(this.socket);
        this.listener.removeProcessor(this);
    }

    private void processVerify() throws IOException {
        this.debug("process Verify");
        int fileId = this.in.readInt();
        long fileLength = this.in.readLong();
        this.debug(" fileId: " + fileId + " fileLength: " + fileLength);
        int maxClusterVerify = OptimizeThread.MAX_CLUSTER_VERIFY;
        if (maxClusterVerify != 0) {
            List<TarFile> files = this.server.main.getDataFiles();
            for (TarFile f : files) {
                int l;
                long pos;
                if (f.getId() != fileId) continue;
                String name = new File(f.getFileName()).getName();
                RandomAccessFile ra = new RandomAccessFile(f.getFileName(), "r");
                long end = Math.min(ra.length(), fileLength);
                long length = end - pos;
                this.debug("  send OP_WRITE " + name + " " + pos + " " + length);
                this.out.write(15);
                this.out.writeUTF(name);
                this.out.writeLong(pos);
                this.out.writeLong(length);
                ra.seek(pos);
                for (pos = Math.max(0L, end - (long)maxClusterVerify); pos < end; pos += (long)l) {
                    l = (int)Math.min(end - pos, (long)this.buffer.length);
                    ra.readFully(this.buffer, 0, l);
                    this.out.write(this.buffer, 0, l);
                }
                ra.close();
            }
        }
        this.out.write(3);
        this.debug("  send OP_OK");
        this.out.flush();
    }

    private void processLock() throws IOException {
        this.debug("process Lock");
        this.server.lock();
        this.server.lockShared();
        int fileId = this.in.readInt();
        long fileLength = this.in.readLong();
        long appendPos = this.in.readLong();
        ArrayList<TarFile> files = new ArrayList<TarFile>();
        this.debug(" fileId: " + fileId + " fileLength: " + fileLength + " appendPos: " + appendPos);
        TarFile last = this.server.main.getLastDataFile();
        if (last.getId() == fileId) {
            files.add(last);
        } else {
            List<TarFile> all = this.server.main.getDataFiles();
            for (TarFile f : all) {
                if (f.getId() < fileId) continue;
                files.add(f);
            }
            if (files.size() == 0 && all.size() > 0) {
                this.debug("  send OP_ABORT");
                this.out.write(13);
                this.out.writeUTF("Cluster node data and shared data are out of sync. Operation stopped.\nCluster node data is newer than the master.\nPlease ensure that the shared path is configured correctly.\nTo continue anyway, please rename the \"copy\" directory on the cluster node and restart.\nLast file in shared: " + last.toString() + "\n" + "Last data file in cluster node: " + fileId + "; length: " + fileLength + "; append position: " + appendPos + "\n" + "File list: " + TarSet.formatList(all));
                this.out.flush();
                this.stop = true;
            }
        }
        for (TarFile f : files) {
            long p = 0L;
            long length = f.getFileLength();
            if (f.getId() < fileId) continue;
            if (f.getId() == fileId) {
                if (length == fileLength) continue;
                p = appendPos;
            }
            this.out.write(4);
            String name = new File(f.getFileName()).getName();
            this.out.writeUTF(name);
            this.out.writeLong(p);
            this.out.writeLong(length - p);
            this.debug("  send OP_WRITE " + name + " " + p + " " + (length - p));
            String fileName = f.getFileName();
            RandomAccessFile ra = new RandomAccessFile(fileName, "r");
            ra.seek(p);
            while (p < length) {
                int l = (int)Math.min(length - p, (long)this.buffer.length);
                ra.readFully(this.buffer, 0, l);
                this.out.write(this.buffer, 0, l);
                p += (long)l;
            }
            ra.close();
        }
        int first = this.server.main.getLastDataFile().getId();
        List<TarFile> list = this.server.main.getDataFiles();
        for (TarFile file : list) {
            if (file.getId() >= first) continue;
            first = file.getId();
        }
        this.debug("  send OP_FIRST first: " + first);
        this.out.write(11);
        this.out.writeInt(first);
        this.out.write(8);
        this.out.writeLong(this.server.main.getLastTransaction());
        this.debug("  send OP_LAST_TRANSACTION " + this.server.main.getLastTransaction());
        this.out.write(3);
        this.debug("  send OP_OK");
        this.out.flush();
    }

    void verify(int fileId, long fileLength) throws IOException {
        block6: {
            int op;
            this.debug("send OP_VERIFY");
            this.out.write(14);
            this.out.writeInt(fileId);
            this.out.writeLong(fileLength);
            this.debug(" fileId: " + fileId + " length: " + fileLength);
            this.out.flush();
            block3: while (true) {
                if ((op = this.in.read()) == 3) break block6;
                switch (op) {
                    case 15: {
                        String name = this.in.readUTF();
                        long pos = this.in.readLong();
                        long length = this.in.readLong();
                        this.debug("  OP_VERIFY_DATA file: " + name + " pos: " + pos + " length: " + length);
                        byte[] compareBuffer = new byte[this.buffer.length];
                        RandomAccessFile ra = this.server.openCopyFile(name, "r");
                        ra.seek(pos);
                        IOException e = null;
                        while (length > 0L) {
                            int l = (int)Math.min(length, (long)this.buffer.length);
                            this.in.readFully(this.buffer, 0, l);
                            ra.readFully(compareBuffer, 0, l);
                            for (int i = 0; i < l; ++i) {
                                if (this.buffer[i] == compareBuffer[i]) continue;
                                e = new IOException("Cluster node data and shared data are out of sync. Operation stopped.\nPlease ensure that the shared path is configured correctly.\nTo continue anyway, please rename the \"copy\" directory on the cluster node and restart.\nFile name: " + name + " position:" + ((long)i + pos) + " expected: " + this.buffer[i] + " got: " + compareBuffer[i] + "\n" + "Last data file in cluster node: " + fileId);
                                break;
                            }
                            if (e != null) break;
                            length -= (long)l;
                            pos += (long)l;
                        }
                        ra.close();
                        if (e == null) continue block3;
                        throw e;
                    }
                }
                break;
            }
            throw new IOException("unexpected response: " + op);
        }
        this.debug("  OP_OK");
    }

    long lock(boolean verify) throws IOException {
        boolean open;
        long result;
        int first;
        long lastDataFileLength;
        int lastDataFileId;
        block20: {
            int op;
            this.debug("send OP_LOCK");
            this.out.write(1);
            TarFile lastDataFile = this.server.copy.getLastDataFile();
            lastDataFileId = lastDataFile.getId();
            lastDataFileLength = lastDataFile.getFileLength();
            this.out.writeInt(lastDataFileId);
            this.out.writeLong(lastDataFileLength);
            this.out.writeLong(lastDataFile.getAppendPos());
            first = 0;
            this.debug(" fileId: " + lastDataFile.getId() + " pos: " + lastDataFile.getAppendPos());
            this.out.flush();
            result = 0L;
            open = true;
            block6: while (true) {
                if ((op = this.in.read()) == 3) break block20;
                switch (op) {
                    case 13: {
                        String message = this.in.readUTF();
                        if (open) {
                            this.server.copy.close(false);
                            open = false;
                        }
                        throw new IOException("Aborting: " + message);
                    }
                    case 4: {
                        long length;
                        if (open) {
                            this.server.copy.close(false);
                            open = false;
                        }
                        String name = this.in.readUTF();
                        long pos = this.in.readLong();
                        this.debug("  OP_WRITE file: " + name + " pos: " + pos + " length: " + length);
                        RandomAccessFile ra = this.server.openCopyFile(name, "rw");
                        if (length < 0L) {
                            ra.setLength(pos + length);
                        } else {
                            int l;
                            ra.seek(pos);
                            for (length = this.in.readLong(); length > 0L; length -= (long)l) {
                                l = (int)Math.min(length, (long)this.buffer.length);
                                this.in.readFully(this.buffer, 0, l);
                                ra.write(this.buffer, 0, l);
                            }
                        }
                        ra.close();
                        continue block6;
                    }
                    case 8: {
                        result = this.in.readLong();
                        this.debug("  OP_LAST_TRANSACTION result: " + result);
                        continue block6;
                    }
                    case 11: {
                        first = this.in.readInt();
                        this.debug("  OP_FIRST first: " + first);
                        continue block6;
                    }
                }
                break;
            }
            throw new IOException("unexpected response: " + op);
        }
        this.debug("  OP_OK");
        if (verify) {
            this.verify(lastDataFileId, lastDataFileLength);
        }
        if (!open) {
            this.server.reopenCopy();
        }
        List<TarFile> list = this.server.copy.getDataFiles();
        for (TarFile file : list) {
            boolean delete;
            if (file.getId() >= first || !this.server.copy.canDelete()) continue;
            Calendar earliestDelete = Calendar.getInstance();
            earliestDelete.setTimeInMillis(file.getLastModified());
            Duration maxAge = this.server.copy.getConfig().getMaximumAge();
            if (maxAge == null) {
                delete = true;
            } else {
                maxAge.addTo(earliestDelete);
                long earliest = earliestDelete.getTimeInMillis();
                if (earliest > Calendar.getInstance().getTimeInMillis()) {
                    this.debug("  don't delete yet: " + (Calendar.getInstance().getTimeInMillis() - earliest) + " " + file.getFileName());
                    delete = false;
                } else {
                    delete = true;
                }
            }
            if (!delete) continue;
            this.server.copy.deleteDataFile(file.getId());
        }
        if (first > lastDataFileId) {
            Logger log = ReplicatingTarSet.log;
            log.info("All tar file are new: re-creating index*.tar files");
            String dir = this.server.copy.getIndex().getDirectory();
            this.server.copy.close(true);
            IndexSet.deleteAll(dir);
            this.server.reopenCopy();
        }
        return result;
    }

    void unlock() throws IOException {
        this.debug("send OP_UNLOCK");
        this.out.write(2);
        this.out.flush();
    }

    private void processUnlock() {
        this.debug("process Unlock");
        this.server.unlockShared();
        this.server.unlock();
    }

    void stopMaster() throws IOException {
        this.debug("send OP_STOP_MASTER");
        this.out.write(12);
        this.out.flush();
        int reply = this.in.read();
        if (reply == 12) {
            ReplicatingTarSet.log.warn("Current master is preferred master as well");
        } else if (reply == 3) {
            // empty if block
        }
        ReplicatingTarSet.log.info("Current master is stopped");
    }
}

