/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import com.day.crx.cluster.ClusterController;
import com.day.crx.persistence.tar.Optimize;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.ReplicationProcessor;
import com.day.crx.persistence.tar.TarPersistenceManager;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarSetConfig;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarSetStatistics;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexSet;
import com.day.crx.util.RepositoryLockMechanismFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.util.RepositoryLock;
import org.apache.jackrabbit.core.util.RepositoryLockMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatingTarSet
implements TarSetHandler {
    static final String COPY_DIR = "copy";
    static Logger log = LoggerFactory.getLogger(ReplicatingTarSet.class);
    private static final int DEFAULT_CONNECT_TIMEOUT = 2000;
    private static final int CONNECT_TIMEOUT = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.ConnectTimeout", 2000);
    private static final String LISTENER_KEY = "address";
    private static final String CHECK_KEY = "check";
    private static final String LISTENER_PROPERTIES = "listener.properties";
    private static final String VERSION = "1.01";
    public TarSet copy = new TarSet();
    TarSetHandler main = new TarSet();
    private final TarPersistenceManager manager;
    private int lockTimeout;
    private String localPath;
    private String copyPath;
    private String fileMode;
    private String lockClass = RepositoryLock.class.getName();
    private final ReentrantLock lock = new ReentrantLock();
    private ReplicationListener replicationListener;
    private ReplicationProcessor processor;
    private RepositoryLockMechanism controlLock;
    private boolean isMaster;
    private int lockSharedCount;
    private long lastTransaction;
    private long currentTransaction;
    private String checkKey;
    private boolean compressFiles;
    private boolean logEverything;
    private long startTime;
    private int maxFileSize;
    private boolean closed;
    private int optimizeCount = 1;
    private double optimizeSleep;
    private boolean preferredMaster;
    private int mergeIndexWhenClosing = 500;
    private TarSetConfig config = new TarSetConfig();
    private long syncNext;
    private String bindAddress;
    private int[] portArray = new int[]{0};
    private TarSetStatistics tarSetStatistics;

    public ReplicatingTarSet(TarPersistenceManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        OptimizeThread.getInstance().removeTarSet(this);
        ReplicatingTarSet replicatingTarSet = this;
        synchronized (replicatingTarSet) {
            this.lock();
            try {
                if (this.replicationListener != null) {
                    this.replicationListener.stopNow();
                    this.replicationListener = null;
                }
                if (this.processor != null) {
                    this.processor.stopNow();
                    this.processor = null;
                }
                this.main.unlockShared();
                this.isMaster = false;
                this.main = TarUtils.closeSilently(this.main);
                this.copy = TarUtils.closeSilently(this.copy);
                this.checkKey = null;
                this.lockSharedCount = 0;
                this.lastTransaction = 0L;
                this.currentTransaction = 0L;
                if (this.controlLock != null) {
                    try {
                        this.controlLock.release();
                    }
                    catch (RepositoryException e) {
                        log.warn("Could not unlock", (Throwable)e);
                    }
                    this.controlLock = null;
                }
                Object var4_3 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.unlock();
                throw throwable;
            }
            this.controlLock = null;
            this.lockTimeout = 1;
            this.closed = true;
        }
    }

    void lock() throws IOException {
        try {
            int timeout;
            int n = timeout = this.lockTimeout == 0 ? Integer.MAX_VALUE : this.lockTimeout;
            if (!this.lock.attempt((long)timeout)) {
                throw new IOException("Lock timeout");
            }
        }
        catch (InterruptedException e) {
            IOException e2 = new IOException("Lock timeout");
            e2.initCause(e);
            throw e2;
        }
    }

    void unlock() {
        try {
            this.lock.release();
        }
        catch (Error e) {
            log.warn("Not locked", (Throwable)e);
        }
    }

    private void checkLockShared() {
        TarUtils.check(this.lockSharedCount > 0, "Shared data not locked: " + this.lockSharedCount);
    }

    @Override
    public IndexEntry append(NodeId id, int type, byte[] data) throws IOException {
        return this.append(id, type, data, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexEntry append(NodeId id, int type, byte[] data, long time) throws IOException {
        this.checkLockShared();
        this.lock();
        try {
            if (this.isMaster) {
                this.main.append(id, type, data, time);
            } else {
                this.processor.append(this.currentTransaction, id, type, data, time);
            }
            IndexEntry indexEntry = this.copy.append(id, type, data, time);
            Object var8_6 = null;
            this.unlock();
            return indexEntry;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendCommit(long tx) throws IOException {
        this.checkLockShared();
        this.lock();
        try {
            if (this.isMaster) {
                this.main.appendCommit(tx);
            } else {
                this.processor.appendCommit(tx);
            }
            this.copy.appendCommit(tx);
            this.currentTransaction = 0L;
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendRollback(long tx) throws IOException {
        this.checkLockShared();
        this.lock();
        try {
            if (this.isMaster) {
                this.main.appendRollback(tx);
            } else {
                this.processor.appendRollback(tx);
            }
            this.copy.appendRollback(tx);
            this.currentTransaction = 0L;
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransaction(long tx) throws IOException {
        this.lock();
        try {
            if (this.isMaster) {
                this.main.setTransaction(tx);
            }
            this.copy.setTransaction(tx);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public long getTransaction() {
        if (this.isMaster) {
            return this.main.getTransaction();
        }
        return this.copy.getTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(NodeId id, int type) throws IOException {
        this.lock();
        try {
            boolean bl = this.copy.exists(id, type);
            Object var5_4 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean getCompressFiles() {
        return this.compressFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexSet getIndex() throws IOException {
        this.lock();
        try {
            IndexSet indexSet = this.copy.getIndex();
            Object var3_2 = null;
            this.unlock();
            return indexSet;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexEntry getIndexEntry(NodeId id, int type) throws IOException {
        this.lock();
        try {
            IndexEntry indexEntry = this.copy.getIndexEntry(id, type);
            Object var5_4 = null;
            this.unlock();
            return indexEntry;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(NodeId id, int type) throws IOException {
        this.lock();
        try {
            InputStream inputStream = this.copy.getInputStream(id, type);
            Object var5_4 = null;
            this.unlock();
            return inputStream;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean getLogEverything() {
        return this.logEverything;
    }

    @Override
    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    @Override
    public boolean getOptimizeWhenIdle() {
        return false;
    }

    @Override
    public TarSetStatistics getTarSetStatistics() {
        return this.tarSetStatistics;
    }

    @Override
    public void setTarSetStatistics(TarSetStatistics value) {
        this.tarSetStatistics = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockShared() throws IOException {
        if (this.closed) {
            throw new IOException("Closed");
        }
        this.lock();
        boolean success = false;
        try {
            if (this.lockSharedCount > 0) {
                if (this.lockSharedCount > 20) {
                    throw new IOException("Internal error: shared lock count=" + this.lockSharedCount);
                }
            } else if (!this.isMaster) {
                this.lastTransaction = this.processor.lock(false);
            }
            ++this.lockSharedCount;
            success = true;
            Object var3_2 = null;
            if (!success) {
                this.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!success) {
                this.unlock();
            }
            throw throwable;
        }
    }

    @Override
    public void lockShared(boolean write) throws IOException {
        this.lockShared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveListenerAddress(String controlFile, String listenerAddress) throws IOException {
        Properties prop = new Properties();
        prop.setProperty(LISTENER_KEY, listenerAddress);
        this.checkKey = "1.01-" + Math.random();
        prop.setProperty(CHECK_KEY, this.checkKey);
        OutputStream out = null;
        try {
            FileSystem fs;
            FileSystem fileSystem = fs = this.manager == null ? null : this.manager.getSharedFileSystem();
            if (fs == null) {
                out = new FileOutputStream(controlFile);
            } else {
                try {
                    if (!fs.exists("")) {
                        fs.createFolder("");
                    }
                    out = fs.getOutputStream(LISTENER_PROPERTIES);
                }
                catch (FileSystemException e) {
                    throw (IOException)new IOException(e.toString()).initCause(e);
                }
            }
            prop.store(out, this.getClass().getName());
            Object var8_7 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            out.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties readControlFile(String controlFile) {
        Properties properties;
        InputStream in;
        block12: {
            Properties properties2;
            block11: {
                Properties properties3;
                block10: {
                    in = null;
                    try {
                        try {
                            FileSystem fs;
                            Properties prop = new Properties();
                            FileSystem fileSystem = fs = this.manager == null ? null : this.manager.getSharedFileSystem();
                            if (fs == null) {
                                if (!new File(controlFile).exists()) {
                                    properties3 = null;
                                    Object var7_12 = null;
                                    break block10;
                                }
                                in = new FileInputStream(controlFile);
                            } else {
                                if (!fs.exists(LISTENER_PROPERTIES)) {
                                    properties2 = null;
                                    break block11;
                                }
                                in = fs.getInputStream(LISTENER_PROPERTIES);
                            }
                            prop.load(in);
                            properties = prop;
                            break block12;
                        }
                        catch (FileSystemException e) {
                            log.warn("Error reading from file " + controlFile + " " + (Object)((Object)e), (Throwable)e);
                            Properties properties4 = null;
                            Object var7_15 = null;
                            TarUtils.closeSilently(in);
                            return properties4;
                        }
                        catch (IOException e) {
                            log.warn("Error reading from file " + controlFile + " " + e, (Throwable)e);
                            Properties properties5 = null;
                            Object var7_16 = null;
                            TarUtils.closeSilently(in);
                            return properties5;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_17 = null;
                        TarUtils.closeSilently(in);
                        throw throwable;
                    }
                }
                TarUtils.closeSilently(in);
                return properties3;
            }
            Object var7_13 = null;
            TarUtils.closeSilently(in);
            return properties2;
        }
        Object var7_14 = null;
        TarUtils.closeSilently(in);
        return properties;
    }

    private String createListener() throws IOException {
        try {
            InetAddress bindInetAddress = this.getBindInetAddress();
            InetAddress addr = InetAddress.getLocalHost();
            InetAddress[] list = InetAddress.getAllByName(addr.getHostAddress());
            StringBuffer buff = new StringBuffer();
            if (bindInetAddress != null) {
                buff.append(bindInetAddress.getHostAddress());
            }
            for (int i = 0; i < list.length; ++i) {
                if (buff.length() > 0) {
                    buff.append(",");
                }
                buff.append(list[i].getHostAddress());
            }
            ServerSocket listenerSocket = ClusterController.openServerSocket(this.portArray, bindInetAddress);
            this.replicationListener = new ReplicationListener(this, listenerSocket);
            return buff.toString() + ":" + listenerSocket.getLocalPort();
        }
        catch (IOException e) {
            log.error("Error trying to create listener; bindAddress=" + this.bindAddress, (Throwable)e);
            throw e;
        }
    }

    private InetAddress getBindInetAddress() throws UnknownHostException {
        if (this.bindAddress == null || this.bindAddress.trim().length() == 0) {
            return null;
        }
        InetAddress address = InetAddress.getByName(this.bindAddress);
        return address;
    }

    private boolean connect(String address, String key) {
        try {
            String[] addresses;
            int idx = address.lastIndexOf(58);
            String portName = address.substring(idx + 1);
            int port = Integer.parseInt(portName);
            address = address.substring(0, idx);
            for (String addr : addresses = address.split(",")) {
                try {
                    this.debug("Trying: " + addr + ":" + port);
                    Socket socket = ReplicatingTarSet.connect(InetAddress.getByName(addr), port);
                    this.processor = new ReplicationProcessor(this, socket, null);
                    this.processor.connect(key);
                    this.debug("OK");
                    return true;
                }
                catch (Exception e) {
                    this.debug("Error: " + e);
                }
            }
        }
        catch (Exception e) {
            log.info("Can not connect to " + address + ": " + e);
            log.debug("Error trying to connect to " + address, (Throwable)e);
        }
        return false;
    }

    void debug(String s) {
        if (log.isDebugEnabled()) {
            String l = this.localPath.replace('\\', '/');
            String[] parts = l.split("/");
            l = parts.length > 2 ? parts[parts.length - 2] : this.localPath;
            log.debug(l + " " + (this.isMaster ? "(server)" : "(client)") + s);
        }
    }

    private void startListener() {
        Thread t = new Thread(this.replicationListener);
        t.setName("ReplicationListener " + this.replicationListener.toString());
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void open(String sharedPath, String localPath, boolean cluster, int lockTimeout, String fileMode) throws IOException {
        this.closed = false;
        this.localPath = localPath;
        this.copyPath = localPath + "/" + COPY_DIR;
        this.lockTimeout = lockTimeout;
        this.fileMode = fileMode;
        this.electMaster(sharedPath);
        if (this.isMaster) {
            this.copy.setOptimize(false);
            try {
                this.copy.open(this.copyPath, this.copyPath, false, lockTimeout, fileMode);
            }
            catch (IOException e) {
                try {
                    this.controlLock.release();
                }
                catch (RepositoryException e2) {
                    log.warn("Error unlocking", (Throwable)e2);
                }
                throw e;
            }
            this.main.setScanFileId(this.copy.getScanFileId());
            this.main.setScanPos(this.copy.getScanPos());
            this.main.setOptimize(false);
            this.main.setUseIndex(false);
            this.main.open(sharedPath, localPath, cluster, lockTimeout, fileMode);
            this.compareFileLists();
            this.main.lockShared();
            this.startListener();
        } else {
            this.copy.setAutoSwitch(false);
            this.copy.setOptimize(false);
            this.copy.open(this.copyPath, this.copyPath, false, lockTimeout, fileMode);
        }
        if (this.isMaster) {
            InetAddress address = this.getBindInetAddress();
            if (address == null) {
                address = InetAddress.getLocalHost();
            }
            Socket s = ReplicatingTarSet.connect(address, this.replicationListener.listenerSocket.getLocalPort());
            ReplicationProcessor p = new ReplicationProcessor(this, s, null);
            try {
                p.connect(this.checkKey);
                p.lock(true);
                p.unlock();
                p.stopNow();
            }
            catch (IOException e) {
                this.copy.close();
                this.main.close();
                try {
                    this.controlLock.release();
                }
                catch (RepositoryException e2) {
                    log.warn("Error unlocking", (Throwable)e2);
                }
                throw e;
            }
        }
        this.lockShared();
        this.unlockShared();
        OptimizeThread.getInstance().addTarSet(this);
    }

    private void electMaster(String sharedPath) throws IOException {
        String controlPath = sharedPath + "/control";
        String controlFile = controlPath + "/" + LISTENER_PROPERTIES;
        long start = System.currentTimeMillis();
        String listenerAddress = null;
        int i = 0;
        while (true) {
            String k;
            TarUtils.createDirectory(controlPath);
            TarUtils.createDirectory(this.copyPath);
            Properties prop = this.readControlFile(controlFile);
            if (prop != null && this.connect(listenerAddress = prop.getProperty(LISTENER_KEY), k = prop.getProperty(CHECK_KEY))) {
                if (!this.preferredMaster) {
                    this.isMaster = false;
                    break;
                }
                this.processor.stopMaster();
            }
            listenerAddress = this.createListener();
            try {
                String lockClassMaster = this.config.getLockClassMaster();
                if (lockClassMaster == null) {
                    lockClassMaster = this.lockClass;
                }
                this.controlLock = RepositoryLockMechanismFactory.createInstance(lockClassMaster);
                this.controlLock.init(controlPath);
            }
            catch (RepositoryException e) {
                this.controlLock = null;
                throw (IOException)new IOException(e.toString()).initCause(e);
            }
            try {
                this.controlLock.acquire();
                if (this.manager != null && !this.manager.attachSharedStorage()) {
                    this.controlLock.release();
                    throw new IOException("Could not attach shared storage");
                }
                this.isMaster = true;
            }
            catch (Exception e) {
                long time;
                if (i == 0) {
                    log.warn("Could not acquire the lock on " + controlPath, (Throwable)e);
                } else {
                    log.warn("Could not acquire the lock on " + controlPath + ": " + e);
                }
                if (this.lockTimeout > 0 && (time = System.currentTimeMillis() - start) > (long)this.lockTimeout) {
                    throw new IOException("Lock timeout trying to lock " + controlPath);
                }
                ++i;
                continue;
            }
            break;
        }
        if (this.isMaster) {
            this.saveListenerAddress(controlFile, listenerAddress);
        }
    }

    private void compareFileLists() throws IOException {
        List<TarFile> listMain = this.main.getDataFiles();
        List<TarFile> listCopy = this.copy.getDataFiles();
        int idxMain = 0;
        int idxCopy = 0;
        boolean outOfSync = false;
        while (idxMain < listMain.size() || idxCopy < listCopy.size()) {
            TarFile c;
            TarFile m = idxMain < listMain.size() ? listMain.get(idxMain) : null;
            TarFile tarFile = c = idxCopy < listCopy.size() ? listCopy.get(idxCopy) : null;
            if (m != null && c != null) {
                if (m.getId() < c.getId()) {
                    outOfSync = true;
                    break;
                }
                if (m.getId() > c.getId()) {
                    ++idxCopy;
                    continue;
                }
                ++idxMain;
                ++idxCopy;
                continue;
            }
            if (c != null && m == null) {
                outOfSync = true;
                break;
            }
            if (c != null || m == null) continue;
            ++idxMain;
        }
        if (outOfSync) {
            this.main.close();
            this.copy.close();
            String message = "Cluster node data and shared data are out of sync. Operation stopped.\nPlease ensure that the shared path is configured correctly.\nTo continue anyway, please rename the \"copy\" directory on the cluster node and restart.\nThe data*.tar file list in the shared path is: " + TarSet.formatList(listMain) + "\n" + "The data*.tar file list in the local copy directory is: " + TarSet.formatList(listCopy) + "\n";
            IOException e = new IOException("Aborting: " + message);
            log.error(message, (Throwable)e);
            try {
                this.controlLock.release();
            }
            catch (RepositoryException e2) {
                log.warn("Could not unlock", (Throwable)e2);
            }
            throw e;
        }
    }

    private static Socket connect(InetAddress address, int port) throws IOException {
        Socket socket = new Socket();
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(address, port), CONNECT_TIMEOUT);
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternalChanges() throws IOException {
        if (!this.isMaster) {
            this.lock();
            try {
                this.lastTransaction = this.processor.lock(false);
                this.processor.unlock();
                Object var2_1 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.unlock();
                throw throwable;
            }
        }
    }

    @Override
    public void setCompressFiles(boolean compressFiles) {
        this.compressFiles = compressFiles;
        this.main.setCompressFiles(compressFiles);
        this.copy.setCompressFiles(compressFiles);
    }

    @Override
    public void setFailOnError(boolean failOnError) {
        this.main.setFailOnError(failOnError);
        this.copy.setFailOnError(failOnError);
    }

    @Override
    public void setLogEverything(boolean logEverything) {
        this.logEverything = logEverything;
        this.main.setLogEverything(logEverything);
        this.copy.setLogEverything(logEverything);
    }

    @Override
    public void setMaxFileSize(int maxFileSize) {
        this.maxFileSize = maxFileSize;
        this.main.setMaxFileSize(maxFileSize);
        this.copy.setMaxFileSize(maxFileSize);
    }

    @Override
    public int getMergeIndexWhenClosing() {
        return this.mergeIndexWhenClosing;
    }

    @Override
    public void setMergeIndexWhenClosing(int mergeIndexWhenClosing) {
        this.mergeIndexWhenClosing = mergeIndexWhenClosing;
        this.copy.setMergeIndexWhenClosing(mergeIndexWhenClosing);
        this.main.setMergeIndexWhenClosing(mergeIndexWhenClosing);
    }

    @Override
    public void setOptimizeWhenIdle(boolean optimizeWhenIdle) {
    }

    @Override
    public long getLastTransaction() {
        if (this.isMaster) {
            return Math.max(this.main.getLastTransaction(), this.copy.getLastTransaction());
        }
        return Math.max(this.lastTransaction, this.copy.getLastTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch() {
        if (this.closed) {
            return;
        }
        try {
            this.lock();
            try {
                if (this.isMaster) {
                    this.main.touch();
                }
                if (this.copy != null) {
                    this.copy.touch();
                }
                Object var2_1 = null;
                this.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.unlock();
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void unlockShared() {
        if (--this.lockSharedCount < 1) {
            if (this.lockSharedCount < 0) {
                log.warn("Lock count: " + this.lockSharedCount);
                this.lockSharedCount = 0;
            }
            if (!this.isMaster) {
                try {
                    if (this.processor != null) {
                        this.processor.unlock();
                    }
                }
                catch (Exception e) {
                    log.warn("Could not unlock", (Throwable)e);
                }
            }
        }
        this.unlock();
    }

    @Override
    public void startTransaction(long tx) throws IOException {
        this.currentTransaction = tx;
        if (this.isMaster) {
            this.main.startTransaction(tx);
        }
        this.copy.startTransaction(tx);
    }

    void reopenCopy() throws IOException {
        this.startTime();
        TarSet newCopy = new TarSet();
        newCopy.setCompressFiles(this.copy.getCompressFiles());
        newCopy.setOptimizeWhenIdle(this.copy.getOptimizeWhenIdle());
        newCopy.setLogEverything(this.copy.getLogEverything());
        newCopy.setFailOnError(this.copy.getFailOnError());
        newCopy.setMaxFileSize(this.copy.getMaxFileSize());
        newCopy.setOptimizeSleep(this.copy.getOptimizeSleep());
        newCopy.setAutoSwitch(this.copy.getAutoSwitch());
        newCopy.setLockClass(this.copy.getLockClass());
        newCopy.setConfig(this.config);
        newCopy.setOptimize(false);
        newCopy.setMergeIndexWhenClosing(this.copy.getMergeIndexWhenClosing());
        newCopy.open(this.copyPath, this.copyPath, false, this.lockTimeout, this.fileMode);
        this.copy = newCopy;
        this.stopTime("reopenCopy");
    }

    private void startTime() {
        this.startTime = System.currentTimeMillis();
    }

    private void stopTime(String task) {
        long time = System.currentTimeMillis() - this.startTime;
        log.debug("time:" + task + " " + time);
    }

    void checkKey(String key) throws IOException {
        if (!key.equals(this.checkKey)) {
            throw new IOException("Unexpected key: " + key + " expected: " + this.checkKey);
        }
    }

    RandomAccessFile openCopyFile(String name, String mode) throws FileNotFoundException {
        return new RandomAccessFile(new File(this.copyPath, name), mode);
    }

    @Override
    public long getLastTouch() {
        if (this.copy == null) {
            return 0L;
        }
        return this.copy.getLastTouch();
    }

    @Override
    public boolean getOptimizeNow() {
        if (this.isMaster) {
            return this.main.getOptimizeNow();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchDataFile(boolean compress) throws IOException {
        TarUtils.check(this.isMaster, "Only the master may switch data files");
        this.lock();
        try {
            if (this.isMaster) {
                this.main.switchDataFile(compress);
                this.copy.switchDataFile(compress);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public boolean canDelete() {
        TarUtils.check(this.isMaster, "Only the master may delete");
        boolean result = this.isMaster ? this.main.canDelete() : false;
        log.debug("canDelete: " + result);
        return result;
    }

    @Override
    public void deleteDataFile(int id) throws IOException {
        TarUtils.check(this.isMaster, "Only the master may delete data files");
        log.debug("deleteDataFile: " + id);
        if (this.isMaster) {
            this.main.deleteDataFile(id);
            this.copy.deleteDataFile(id);
        }
    }

    @Override
    public Optimize createOptimizer() {
        TarUtils.check(this.isMaster, "Only the master may optimize");
        return new Optimize(this.copy, this);
    }

    @Override
    public void setOptimizeNowEnd() {
        log.debug("setOptimizeNowEnd");
        this.main.setOptimizeNowEnd();
    }

    @Override
    public List<TarFile> getDataFiles() {
        if (this.isMaster) {
            return this.main.getDataFiles();
        }
        return this.copy.getDataFiles();
    }

    @Override
    public void kill() {
        if (this.closed) {
            return;
        }
        OptimizeThread.getInstance().removeTarSet(this);
        if (this.isMaster) {
            this.replicationListener.stopNow();
            this.replicationListener = null;
            this.isMaster = false;
            this.main.kill();
            this.main = null;
            try {
                this.controlLock.release();
            }
            catch (RepositoryException e) {
                log.warn("Could not unlock", (Throwable)e);
            }
            this.controlLock = null;
        } else {
            this.processor.stopNow();
            this.processor = null;
        }
        this.copy.kill();
        this.copy = null;
        this.lockTimeout = 1;
        this.closed = true;
    }

    void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    void setPortArray(int[] portArray) {
        this.portArray = portArray;
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public int getOptimizeCount() {
        return this.optimizeCount;
    }

    @Override
    public void setOptimizeCount(int optimizeCount) {
        this.optimizeCount = optimizeCount;
    }

    @Override
    public double getOptimizeSleep() {
        return this.optimizeSleep;
    }

    @Override
    public void setOptimizeSleep(double optimizeSleep) {
        this.optimizeSleep = optimizeSleep;
    }

    @Override
    public String getLockClass() {
        return this.lockClass;
    }

    @Override
    public void setLockClass(String lockClass) {
        this.lockClass = lockClass;
        this.main.setLockClass(lockClass);
        this.copy.setLockClass(lockClass);
    }

    void setPreferredMaster(boolean preferredMaster) {
        this.preferredMaster = preferredMaster;
    }

    public boolean isPreferredMaster() {
        return this.preferredMaster;
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reopen() throws IOException {
        this.lock();
        try {
            this.manager.setPreferredMaster(false);
            this.manager.reopenTarSet();
            Object var2_1 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public void setConfig(TarSetConfig config) {
        this.config = config;
        this.main.setConfig(config);
        this.copy.setConfig(config);
    }

    @Override
    public TarSetConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean sync(boolean force) {
        long now;
        block18: {
            boolean lockShared;
            if (this.isMaster || this.closed) {
                return false;
            }
            now = System.currentTimeMillis();
            if (!force && now < this.syncNext) {
                return false;
            }
            boolean locked = false;
            try {
                try {
                    block16: {
                        if (this.lock.attempt(1000L)) {
                            locked = true;
                            lockShared = false;
                            try {
                                try {
                                    this.lockShared();
                                    lockShared = true;
                                }
                                catch (IOException e) {
                                    Object var8_7 = null;
                                    if (lockShared) {
                                        this.unlockShared();
                                    }
                                    break block16;
                                }
                                Object var8_6 = null;
                                if (lockShared) {
                                    this.unlockShared();
                                }
                            }
                            catch (Throwable throwable) {
                                Object var8_8 = null;
                                if (!lockShared) throw throwable;
                                this.unlockShared();
                                throw throwable;
                            }
                        }
                    }
                    lockShared = true;
                    Object var10_11 = null;
                    if (!locked) return lockShared;
                }
                catch (InterruptedException e) {
                    Object var10_12 = null;
                    if (!locked) break block18;
                    this.lock.release();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!locked) throw throwable;
                this.lock.release();
                throw throwable;
            }
            this.lock.release();
            return lockShared;
        }
        this.syncNext = now + (long)OptimizeThread.getInstance().getSyncDelay();
        return false;
    }

    @Override
    public void setOptimize(boolean b) {
    }

    @Override
    public void setScanFileId(int scanFileId) {
    }

    @Override
    public void setScanPos(long scanPos) {
    }

    @Override
    public void setUseIndex(boolean b) {
    }

    @Override
    public TarFile getLastDataFile() {
        return this.copy.getLastDataFile();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public long[] findTransactionStart(long transaction, boolean previous) throws IOException {
        return this.copy.findTransactionStart(transaction, previous);
    }

    @Override
    public void truncate(int fileId, long pos) throws IOException {
        this.copy.truncate(fileId, pos);
        if (this.main != null) {
            this.main.truncate(fileId, pos);
        }
    }

    static class ReplicationListener
    implements Runnable {
        protected ServerSocket listenerSocket;
        private final ReplicatingTarSet rep;
        private boolean stop;
        private final HashSet<ReplicationProcessor> runningProcessors = new HashSet();

        ReplicationListener(ReplicatingTarSet rep, ServerSocket listenerSocket) {
            this.rep = rep;
            this.listenerSocket = listenerSocket;
        }

        public String toString() {
            return this.listenerSocket.toString();
        }

        public synchronized void stopNow() {
            this.stop = true;
            this.listenerSocket = TarUtils.closeSilently(this.listenerSocket);
            Object[] list = this.runningProcessors.toArray();
            for (int i = 0; i < list.length; ++i) {
                ReplicationProcessor p = (ReplicationProcessor)list[i];
                p.stopNow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    while (!this.stop) {
                        Socket s = this.listenerSocket.accept();
                        s.setTcpNoDelay(true);
                        ReplicationListener replicationListener = this;
                        synchronized (replicationListener) {
                            ReplicationProcessor thread = new ReplicationProcessor(this.rep, s, this);
                            thread.setName(this.getClass().getName());
                            this.runningProcessors.add(thread);
                            thread.start();
                        }
                    }
                    this.listenerSocket.close();
                }
                catch (Exception e) {
                    if (this.stop) break block6;
                    log.warn("Error in listener", (Throwable)e);
                }
            }
        }

        public synchronized void removeProcessor(ReplicationProcessor processor) {
            this.runningProcessors.remove(processor);
        }
    }
}

