/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReentrantLockWithInfo {
    static Logger log = LoggerFactory.getLogger(ReentrantLockWithInfo.class);
    private static final int LOCKED_WARN_INTERVAL = Integer.getInteger("com.day.crx.persistence.tar.LockWarnInterval", 60000);
    private volatile ReentrantLock lock = new ReentrantLock();
    private volatile Thread lockOwner;
    private volatile Error lockOwnerTrace;
    private volatile String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean tryLock() {
        boolean result = this.lock.tryLock();
        if (result) {
            this.locked();
        }
        return result;
    }

    public boolean tryLock(long millisecondTimeout) throws InterruptedException {
        boolean result = this.internalTryLock(millisecondTimeout);
        if (result) {
            this.locked();
        }
        return result;
    }

    public void lock() throws InterruptedException {
        int i = 0;
        while (true) {
            if (this.internalTryLock(LOCKED_WARN_INTERVAL)) {
                this.locked();
                return;
            }
            String message = "Lock on " + this.name + " still held by " + this.lockOwner + ": " + i;
            if (this.lockOwnerTrace != null && i == 0) {
                log.warn(message, (Throwable)this.lockOwnerTrace);
            } else {
                log.warn(message);
            }
            ++i;
        }
    }

    private boolean internalTryLock(long milliseconds) throws InterruptedException {
        while (milliseconds > 0L) {
            long timeout = Math.min(1000L, milliseconds);
            if (this.lock.tryLock(timeout, TimeUnit.MILLISECONDS)) {
                return true;
            }
            Thread owner = this.lockOwner;
            if (owner != null && !owner.isAlive()) {
                String message = "Owner is not alive, unlocking";
                log.warn(message);
                this.unlockForce();
            }
            milliseconds -= timeout;
        }
        return false;
    }

    public void unlock() {
        if (this.lock.getHoldCount() == 1) {
            this.lockOwner = null;
            this.lockOwnerTrace = null;
        }
        this.lock.unlock();
    }

    public void unlockForce() {
        try {
            this.unlock();
        }
        catch (IllegalMonitorStateException e) {
            String message = "Unlock force on " + this.name + " still held by " + this.lockOwner;
            if (this.lockOwnerTrace != null) {
                log.warn(message, (Throwable)this.lockOwnerTrace);
            } else {
                log.warn(message);
            }
            this.lockOwner = null;
            this.lockOwnerTrace = null;
            this.lock = new ReentrantLock();
        }
    }

    private void locked() {
        if (this.lock.getHoldCount() == 1) {
            this.lockOwner = Thread.currentThread();
            if (LOCKED_WARN_INTERVAL < 10000) {
                this.lockOwnerTrace = new Error();
            }
        }
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }
}

