/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtil {
    public static String runProcess(List<String> args) {
        try {
            ProcessUtil.logDebug("runProcess args: " + args);
            String[] argList = new String[args.size()];
            args.toArray(argList);
            Process p = Runtime.getRuntime().exec(argList);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Thread threadOut = ProcessUtil.copyInThread(p.getInputStream(), out, false);
            Thread threadErr = ProcessUtil.copyInThread(p.getErrorStream(), out, false);
            p.waitFor();
            int exitValue = p.exitValue();
            threadOut.join();
            threadErr.join();
            String result = new String(out.toByteArray());
            ProcessUtil.logDebug("exitValue=" + exitValue);
            ProcessUtil.logDebug(result);
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static Thread copyInThread(final InputStream in, final OutputStream out, final boolean toSysOut) {
        Thread t = new Thread(){

            public void run() {
                try {
                    while (true) {
                        int x;
                        if ((x = in.read()) < 0) {
                            return;
                        }
                        if (out == null) continue;
                        out.write(x);
                        if (!toSysOut) continue;
                        System.out.print((char)x);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        return t;
    }

    private static void logDebug(String message) {
    }
}

