/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarSetStatistics;
import com.day.crx.persistence.tar.file.TarFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeThreadStatistics {
    private static final int STATS_INTERVAL_MILLIS = 5000;
    private long optimizationWorkKBytes;
    private long optimizationRateKBytesPerSecond;
    private long lastStatsTimestamp;
    private long optimizedBytes;
    private long optimizationRateTimestamp;

    public long getOptimizationWorkKBytes() {
        return this.optimizationWorkKBytes;
    }

    public long getOptimizationRateKBytesPerSecond() {
        return this.optimizationRateKBytesPerSecond;
    }

    void updateOptimizedBytes(long value) {
        if (value < 1L) {
            return;
        }
        this.optimizedBytes += value;
        if (this.optimizationRateTimestamp == 0L) {
            this.optimizationRateTimestamp = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.optimizationRateTimestamp >= 5000L) {
            this.optimizationRateKBytesPerSecond = this.optimizedBytes / 1024L * 1000L / 5000L;
            this.optimizationRateTimestamp = System.currentTimeMillis();
            this.optimizedBytes = 0L;
        }
    }

    void updateStatistics(ArrayList<TarSetHandler> list, boolean forceUpdate) {
        if (!forceUpdate && this.lastStatsTimestamp != 0L && System.currentTimeMillis() - this.lastStatsTimestamp < 5000L) {
            return;
        }
        this.updateTarSetStatistics(list);
        this.updateOptimizationWork(list);
        if (forceUpdate) {
            this.resetOptimizationRate();
        }
    }

    private void updateTarSetStatistics(ArrayList<TarSetHandler> tarSetHandlers) {
        for (TarSetHandler tarSetHandler : tarSetHandlers) {
            TarSetStatistics tarSetStatistics = tarSetHandler.getTarSetStatistics();
            if (tarSetStatistics == null) continue;
            tarSetStatistics.update();
        }
    }

    private void updateOptimizationWork(ArrayList<TarSetHandler> tarSetHandlers) {
        long optimizationWorkBytes = 0L;
        for (TarSetHandler tarSetHandler : tarSetHandlers) {
            optimizationWorkBytes += this.getOptimizationWork(tarSetHandler);
        }
        this.optimizationWorkKBytes = optimizationWorkBytes / 1024L;
        this.lastStatsTimestamp = System.currentTimeMillis();
    }

    private void resetOptimizationRate() {
        this.optimizationRateKBytesPerSecond = 0L;
        this.optimizationRateTimestamp = 0L;
        this.optimizedBytes = 0L;
    }

    private long getOptimizationWork(TarSetHandler tarSetHandler) {
        List<TarFile> tarFiles = tarSetHandler.getDataFiles();
        long work = 0L;
        for (TarFile tarFile : tarFiles) {
            if (!tarFile.getNeedToOptimize()) continue;
            try {
                work += tarFile.getFileLength() - tarFile.getOptimizePos();
            }
            catch (IOException ignore) {}
        }
        return work;
    }
}

