/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.core.backup.BackupBarrier;
import com.day.crx.persistence.tar.Optimize;
import com.day.crx.persistence.tar.OptimizeSchedule;
import com.day.crx.persistence.tar.OptimizeThreadStatistics;
import com.day.crx.persistence.tar.TarSetHandler;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.index.IndexMerger;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeThread
implements Runnable {
    public static final String OPTIMIZE_ONE_MIN_SIZE = "com.day.crx.persistence.tar.OptimizeOneMinSize";
    public static final String OPTIMIZE_READ_INDEX = "com.day.crx.persistence.tar.OptimizeReadIndex";
    public static final int MAX_CLUSTER_VERIFY = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.MaxClusterVerify", 131072);
    public static final int INDEX_MERGE_DELAY = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.IndexMergeDelay", 1);
    public static final boolean BUG_34668 = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.Bug34668", 1) > 0;
    protected static Logger log = LoggerFactory.getLogger(OptimizeThread.class);
    static final boolean LOCK_SHARED = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.LockShared", 0) == 1;
    private static final int SLEEP_LONG = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.SleepLong", 1000);
    private static final int KEEP_RUNNING = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.KeepRunning", 0);
    private static final int MIN_IDLE_TIME = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.MinIdle", 30);
    private static final int DEFAULT_DELETE_DELAY = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.DeleteDelay", 5000);
    private static final int DEFAULT_SYNC_DELAY = OptimizeThread.getIntSetting("com.day.crx.persistence.tar.SyncDelay", 60000);
    private static OptimizeThread instance = new OptimizeThread();
    private static boolean fileSystemTestStarted;
    volatile boolean stop;
    volatile boolean skipOptimization;
    private final HashSet<TarSetHandler> tarsets = new HashSet();
    private final Semaphore optimizingTarSets = new Semaphore(1);
    private final HashMap<File, DeleteTask> tobeDeleted = new HashMap();
    private final Map<String, IndexMerger> indexMergerMap = new HashMap<String, IndexMerger>();
    private volatile Thread thread;
    private volatile long lastAddOrRemove;
    private int deleteDelay = DEFAULT_DELETE_DELAY;
    private int syncDelay = DEFAULT_SYNC_DELAY;
    private int minIdleTime = MIN_IDLE_TIME;
    private BackupBarrier barrier;
    private OptimizeThreadStatistics optimizeThreadStatistics = new OptimizeThreadStatistics();

    public static OptimizeThread getInstance() {
        return instance;
    }

    static int getIntSetting(String name, int defaultValue) {
        String s = System.getProperty(name);
        if (s != null) {
            try {
                return Integer.decode(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public TarSetHandler getTarSet(String localPath) {
        localPath = new File(localPath).getAbsolutePath();
        for (TarSetHandler set : this.tarsets) {
            String l = set.getLocalPath();
            if (!localPath.equals(l = new File(l).getAbsolutePath())) continue;
            return set;
        }
        return null;
    }

    synchronized int getDeleteDelay() {
        return this.deleteDelay;
    }

    public synchronized void setDeleteDelay(int deleteDelay) {
        this.deleteDelay = deleteDelay;
    }

    public synchronized long getOptimizationWorkKBytes() {
        return this.optimizeThreadStatistics.getOptimizationWorkKBytes();
    }

    public synchronized long getOptimizationRateKBytesPerSecond() {
        return this.optimizeThreadStatistics.getOptimizationRateKBytesPerSecond();
    }

    public synchronized void setSyncDelay(int syncDelay) {
        this.syncDelay = syncDelay;
    }

    public int getMinIdleTime() {
        return this.minIdleTime;
    }

    public void setMinIdleTime(int minIdleTime) {
        this.minIdleTime = minIdleTime == -1 ? MIN_IDLE_TIME : minIdleTime;
    }

    public int getSyncDelay() {
        return this.syncDelay;
    }

    synchronized void addTarSet(TarSetHandler set) {
        this.lastAddOrRemove = System.currentTimeMillis();
        this.tarsets.add(set);
        this.startIfRequired();
    }

    public synchronized ArrayList<TarSetHandler> getTarSets() {
        ArrayList<TarSetHandler> list = new ArrayList<TarSetHandler>();
        list.addAll(this.tarsets);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIfRequired() {
        this.startFileSystemTest();
        OptimizeThread optimizeThread = this;
        synchronized (optimizeThread) {
            if (this.thread == null) {
                this.thread = new Thread(this);
                this.thread.setName("Tar PM Optimization");
                this.thread.setDaemon(true);
                this.thread.setPriority(1);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getToBeDeleted() {
        HashMap<File, DeleteTask> hashMap = this.tobeDeleted;
        synchronized (hashMap) {
            return new HashSet<File>(this.tobeDeleted.keySet());
        }
    }

    private synchronized void startFileSystemTest() {
        if (fileSystemTestStarted) {
            return;
        }
        fileSystemTestStarted = true;
        Thread thread = new Thread(){

            public void run() {
                OptimizeThread.this.sleep(20000.0);
                if (!OptimizeThread.this.stop) {
                    TarUtils.getFileSystemError();
                }
            }
        };
        thread.setName("Calculate File System Status");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLater(File file, boolean createDeleteFile) {
        long when = System.currentTimeMillis() + (long)this.deleteDelay;
        log.debug("Scheduled for deleting later " + file.getAbsolutePath());
        DeleteTask task = new DeleteTask(when, file, this.deleteDelay, createDeleteFile);
        if (this.deleteDelay == 0) {
            task.execute();
        } else {
            HashMap<File, DeleteTask> hashMap = this.tobeDeleted;
            synchronized (hashMap) {
                this.tobeDeleted.put(file, task);
            }
            this.startIfRequired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTarSet(TarSetHandler set) {
        boolean waitUntilStopped;
        boolean removed;
        OptimizeThread optimizeThread = this;
        synchronized (optimizeThread) {
            this.lastAddOrRemove = System.currentTimeMillis();
            removed = this.tarsets.remove(set);
            boolean empty = this.tarsets.size() == 0;
            waitUntilStopped = removed && empty && this.thread != null;
        }
        if (removed) {
            try {
                if (this.optimizingTarSets.tryAcquire(60L, TimeUnit.SECONDS)) {
                    this.optimizingTarSets.release();
                } else {
                    log.warn("OptimizeThread still busy after waiting for 60 seconds.");
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for OptimizeThread to become idle.");
            }
        }
        if (waitUntilStopped) {
            this.stop = true;
            try {
                this.thread.join(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.stop = false;
        }
    }

    void sleep(double sleep) {
        int millis = (int)sleep;
        if (sleep != (double)millis && Math.random() <= sleep - (double)millis) {
            ++millis;
        }
        while (millis > 0 && !this.stop) {
            int m = Math.min(10, millis);
            try {
                Thread.sleep(m);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            millis -= m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object var3_2;
            this.barrier = new BackupBarrier();
            this.sleep(1000.0);
            try {
                try {
                    this.loop();
                    var3_2 = null;
                    if (this.barrier == null) break;
                    this.barrier.close();
                    this.barrier = null;
                    break;
                }
                catch (Throwable t) {
                    if (log == null) {
                        System.err.println(this.getClass().getName() + " stopped");
                        var3_2 = null;
                        if (this.barrier == null) break;
                        this.barrier.close();
                        this.barrier = null;
                        break;
                    }
                    log.error("Exception in optimize thread; retrying", t);
                    var3_2 = null;
                    if (this.barrier == null) continue;
                    this.barrier.close();
                    this.barrier = null;
                }
            }
            catch (Throwable throwable) {
                var3_2 = null;
                if (this.barrier != null) {
                    this.barrier.close();
                    this.barrier = null;
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loop() {
        double nextSleep = Math.min(this.deleteDelay, SLEEP_LONG);
        String currentTime = OptimizeSchedule.getTime(System.currentTimeMillis());
        while (true) {
            boolean currentlyOptimizing;
            Object var20_21;
            long now;
            this.sleep(nextSleep);
            this.barrier.waitForBackup();
            if (this.tarsets.size() == 0 && (now = System.currentTimeMillis()) > this.lastAddOrRemove + (long)KEEP_RUNNING) {
                OptimizeThread optimizeThread = this;
                synchronized (optimizeThread) {
                    this.thread = null;
                    return;
                }
            }
            if (this.tobeDeleted.size() > 0) {
                this.deletePending();
            }
            ArrayList<TarSetHandler> list = new ArrayList<TarSetHandler>();
            boolean busy = false;
            this.optimizingTarSets.acquireUninterruptibly();
            try {
                long now2;
                block34: {
                    block33: {
                        OptimizeThread optimizeThread = this;
                        synchronized (optimizeThread) {
                            list.addAll(this.tarsets);
                        }
                        now2 = System.currentTimeMillis();
                        Iterator i$ = list.iterator();
                        while (i$.hasNext()) {
                            TarSetHandler tarset;
                            TarSetHandler tarSetHandler = tarset = (TarSetHandler)i$.next();
                            synchronized (tarSetHandler) {
                                long touch = tarset.getLastTouch();
                                if (touch + (long)this.minIdleTime <= now2) continue;
                            }
                            busy = true;
                            break;
                        }
                        nextSleep = Math.min(this.deleteDelay, SLEEP_LONG);
                        if (busy) break block33;
                        if (!this.skipOptimization) break block34;
                    }
                    var20_21 = null;
                    this.optimizingTarSets.release();
                    continue;
                }
                String lastTime = currentTime;
                currentTime = OptimizeSchedule.getTime(now2);
                currentlyOptimizing = false;
                for (TarSetHandler tarset : list) {
                    this.optimizeThreadStatistics.updateStatistics(list, false);
                    TarSetHandler tarSetHandler = tarset;
                    synchronized (tarSetHandler) {
                        block32: {
                            OptimizeSchedule schedule;
                            block35: {
                                tarset.sync(false);
                                schedule = tarset.getConfig().getSchedule();
                                if (!tarset.getOptimizeWhenIdle() && !tarset.getOptimizeNow()) break block35;
                                if (schedule.needToStop(lastTime, currentTime)) {
                                    this.logIfNotJournal(tarset, "Scheduled optimization stopped at " + currentTime + " (schedule: " + schedule + ") for " + tarset.getLocalPath());
                                    tarset.setOptimizeNowEnd();
                                    this.mergeIndexFile(tarset);
                                    break block32;
                                } else {
                                    nextSleep = Math.min(nextSleep, tarset.getOptimizeSleep());
                                    Optimize optimize = tarset.createOptimizer();
                                    try {
                                        if (optimize != null) {
                                            int count = Math.max(1, tarset.getOptimizeCount());
                                            long optimizedBytes = optimize.optimizeBlocks(count);
                                            currentlyOptimizing = true;
                                            this.optimizeThreadStatistics.updateOptimizedBytes(optimizedBytes);
                                            if (optimizedBytes == -1L && tarset.getOptimizeNow()) {
                                                tarset.setOptimizeNowEnd();
                                            }
                                        }
                                        break block32;
                                    }
                                    catch (IOException e) {
                                        log.error("optimizing " + tarset + ": " + e.toString(), (Throwable)e);
                                        nextSleep += 100.0;
                                        if (tarset.getOptimizeNow()) {
                                            tarset.setOptimizeNowEnd();
                                        }
                                        break block32;
                                    }
                                }
                            }
                            if (schedule.needToStart(lastTime, currentTime)) {
                                this.logIfNotJournal(tarset, "Scheduled optimization started at " + currentTime + " (schedule: " + schedule + ") for " + tarset.getLocalPath());
                                this.mergeIndexFile(tarset);
                                try {
                                    new File(tarset.getLocalPath() + "/" + "optimize.tar").createNewFile();
                                }
                                catch (IOException e) {
                                    log.error("Can not start optimization", (Throwable)e);
                                }
                            }
                            if (schedule.needToStop(lastTime, currentTime)) {
                                this.logIfNotJournal(tarset, "Scheduled optimization finished at " + currentTime + " (schedule: " + schedule + ") for " + tarset.getLocalPath());
                                tarset.setOptimizeNowEnd();
                                this.mergeIndexFile(tarset);
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                var20_21 = null;
                this.optimizingTarSets.release();
                throw throwable;
            }
            var20_21 = null;
            this.optimizingTarSets.release();
            if (currentlyOptimizing) continue;
            this.optimizeThreadStatistics.updateStatistics(list, true);
        }
    }

    private void logIfNotJournal(TarSetHandler tarset, String message) {
        if (!tarset.getConfig().isJournal()) {
            log.info(message);
        }
    }

    private void mergeIndexFile(TarSetHandler tarset) {
        try {
            if (!tarset.isClosed()) {
                IndexSet index = tarset.getIndex();
                index.mergeTopIndexFiles();
            }
        }
        catch (Exception e) {
            log.error("Can not merge index files", (Throwable)e);
        }
    }

    public Map<String, IndexMerger> getIndexMergerMap() {
        return this.indexMergerMap;
    }

    public void setSkipOptimization(boolean skipOptimization) {
        this.skipOptimization = skipOptimization;
    }

    public boolean getSkipOptimization() {
        return this.skipOptimization;
    }

    public void waitForPendingOperations() {
        int i = 0;
        while (this.getToBeDeleted().size() > 0) {
            if (i > 3) {
                log.warn("Skip waiting; pending delete operations: " + this.getToBeDeleted());
                break;
            }
            log.info("Wait for pending delete operations");
            this.deletePending();
            this.sleep(2 * this.getDeleteDelay());
            ++i;
        }
        while (this.getIndexMergerMap().size() > 0) {
            log.info("Wait for pending index merge operations");
            this.sleep(2 * this.getDeleteDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePending() {
        HashMap<File, DeleteTask> hashMap = this.tobeDeleted;
        synchronized (hashMap) {
            Iterator<DeleteTask> it = this.tobeDeleted.values().iterator();
            while (it.hasNext()) {
                DeleteTask task = it.next();
                if (!task.execute()) continue;
                it.remove();
            }
        }
    }

    private static class DeleteTask {
        private static final int MAX_TRIES = 5;
        private final File file;
        private final boolean createDeleteFile;
        private final long deleteDelay;
        private long earliest;
        private int tries;

        DeleteTask(long earliest, File file, long deleteDelay, boolean createDeleteFile) {
            this.file = file;
            this.earliest = earliest;
            this.deleteDelay = deleteDelay;
            this.createDeleteFile = createDeleteFile;
        }

        boolean execute() {
            long now = System.currentTimeMillis();
            if (now < this.earliest) {
                return false;
            }
            if (!this.file.exists()) {
                return true;
            }
            if (this.createDeleteFile) {
                File delete = new File(this.file.getAbsolutePath() + ".delete");
                try {
                    delete.createNewFile();
                    return true;
                }
                catch (IOException e) {
                    log.error("Can not create file " + delete.getAbsolutePath(), (Throwable)e);
                    return false;
                }
            }
            boolean ok = this.file.delete();
            ++this.tries;
            log.debug("delete " + this.file.getAbsolutePath() + ": ok=" + ok);
            if (ok || this.tries > 5) {
                return true;
            }
            this.earliest = System.currentTimeMillis() + this.deleteDelay;
            return false;
        }
    }
}

