/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import java.sql.Time;

public class OptimizeSchedule {
    private String start;
    private String stop;

    public static OptimizeSchedule getInstance(String when) {
        OptimizeSchedule schedule = new OptimizeSchedule();
        if (when != null) {
            String stop;
            String start;
            int dash = when.indexOf(45);
            if (dash < 0) {
                start = when;
                stop = "";
            } else {
                start = when.substring(0, dash);
                stop = when.substring(dash + 1, when.length());
            }
            schedule.start = OptimizeSchedule.parseTime(start);
            schedule.stop = OptimizeSchedule.parseTime(stop);
        }
        return schedule;
    }

    private static String parseTime(String when) {
        if (when == null) {
            return null;
        }
        if ((when = when.trim()).length() == 0) {
            return "";
        }
        int colon = when.indexOf(58);
        if (colon < 0) {
            when = when + ":00";
            colon = when.length() - 1;
        }
        if ((colon = when.indexOf(58, colon + 1)) < 0) {
            when = when + ":00";
        }
        return Time.valueOf(when).toString();
    }

    public String toString() {
        if (this.start == null && this.stop == null) {
            return null;
        }
        if (this.start.length() == 0 && this.stop.length() == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.start);
        if (this.stop.length() > 0) {
            buff.append('-');
            buff.append(this.stop);
        }
        return buff.toString();
    }

    static String getTime(long time) {
        return new Time(time).toString();
    }

    boolean needToStart(String lastTime, String currentTime) {
        return this.testTime(this.start, lastTime, currentTime);
    }

    boolean needToStop(String lastTime, String currentTime) {
        return this.testTime(this.stop, lastTime, currentTime);
    }

    private boolean testTime(String test, String last, String now) {
        if (test == null || test.length() == 0) {
            return false;
        }
        if (last.compareTo(now) > 0) {
            if (last.compareTo(test) < 0) {
                return true;
            }
            return test.compareTo(now) <= 0;
        }
        if (test.compareTo(last) <= 0) {
            return false;
        }
        return test.compareTo(now) <= 0;
    }
}

