/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar;

import com.day.crx.persistence.tar.TarSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.jackrabbit.core.id.NodeId;

public class AppendEvent {
    private static final int APPEND = 0;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private final Pos pos;
    private final int eventType;
    private final long tx;
    private final NodeId id;
    private final int type;
    private final byte[] data;
    private final long time;

    static AppendEvent append(Pos pos, long tx, NodeId id, int type, byte[] data, long time) {
        return new AppendEvent(pos, 0, tx, id, type, data, time);
    }

    static AppendEvent commit(Pos pos, long tx) {
        return new AppendEvent(pos, 1, tx, null, 0, null, 0L);
    }

    static AppendEvent rollback(Pos pos, long tx) {
        return new AppendEvent(pos, 2, tx, null, 0, null, 0L);
    }

    private AppendEvent(Pos pos, int eventType, long tx, NodeId id, int type, byte[] data, long time) {
        this.pos = pos;
        this.eventType = eventType;
        this.tx = tx;
        this.id = id;
        this.type = type;
        this.data = data;
        this.time = time;
    }

    Pos getPos() {
        return this.pos;
    }

    void apply(TarSet set) throws IOException {
        switch (this.eventType) {
            case 0: {
                set.setTransaction(this.tx);
                set.append(this.id, this.type, this.data);
                break;
            }
            case 1: {
                set.appendCommit(this.tx);
                break;
            }
            case 2: {
                set.appendRollback(this.tx);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.pos.getTarFileId());
        out.writeLong(this.pos.getAppendPos());
        out.writeInt(this.eventType);
        out.writeLong(this.tx);
        if (this.eventType == 0) {
            out.writeLong(this.id.getMostSignificantBits());
            out.writeLong(this.id.getLeastSignificantBits());
            out.writeInt(this.type);
            out.writeInt(this.data.length);
            out.write(this.data);
            out.writeLong(this.time);
        }
    }

    int getMemory() {
        int mem = 24;
        if (this.eventType == 0) {
            return mem + 16 + 4 + 4 + this.data.length + 8;
        }
        return mem;
    }

    public static AppendEvent read(DataInput in) throws IOException {
        long time;
        byte[] data;
        int type;
        NodeId id;
        Pos pos = new Pos(in.readInt(), in.readLong());
        int eventType = in.readInt();
        long tx = in.readLong();
        if (eventType == 0) {
            id = new NodeId(in.readLong(), in.readLong());
            type = in.readInt();
            data = new byte[in.readInt()];
            in.readFully(data);
            time = in.readLong();
        } else {
            id = null;
            type = 0;
            data = null;
            time = 0L;
        }
        AppendEvent event = new AppendEvent(pos, eventType, tx, id, type, data, time);
        return event;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pos
    implements Comparable<Pos> {
        private final int tarFileId;
        private final long appendPos;

        Pos(int tarFileId, long appendPos) {
            this.tarFileId = tarFileId;
            this.appendPos = appendPos;
        }

        int getTarFileId() {
            return this.tarFileId;
        }

        long getAppendPos() {
            return this.appendPos;
        }

        @Override
        public int compareTo(Pos other) {
            int c = this.tarFileId - other.tarFileId;
            if (c != 0) {
                return c;
            }
            return this.appendPos < other.appendPos ? -1 : (this.appendPos > other.appendPos ? 1 : 0);
        }
    }
}

