/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.multi;

import java.io.File;
import java.io.Serializable;
import org.apache.jackrabbit.core.fs.BasedFileSystem;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPersistenceManager
implements PersistenceManager {
    private static Logger log = LoggerFactory.getLogger(MultiPersistenceManager.class);
    private String managerClass0;
    private String managerClass1;
    private PersistenceManager[] list;
    private String name;

    public void init(PMContext context) throws Exception {
        this.name = context.getHomeDir().getAbsolutePath();
        int idx = this.name.lastIndexOf(47);
        if (idx < 0) {
            idx = this.name.lastIndexOf(92);
        }
        if (idx >= 0) {
            this.name = this.name.substring(idx);
        }
        this.debug("init");
        int size = 2;
        this.list = new PersistenceManager[size];
        for (int i = 0; i < this.list.length; ++i) {
            PersistenceManager pm;
            String m = i == 0 ? this.managerClass0 : this.managerClass1;
            this.list[i] = pm = (PersistenceManager)Class.forName(m).newInstance();
            PMContext cx = new PMContext(new File(context.getHomeDir().getAbsoluteFile() + "/" + i), (FileSystem)new BasedFileSystem(context.getFileSystem(), "" + i), context.getRootNodeId(), context.getNamespaceRegistry(), context.getNodeTypeRegistry(), context.getDataStore(), context.getRepositoryStatistics());
            pm.init(cx);
        }
    }

    public void close() throws Exception {
        this.debug("close");
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].close();
        }
    }

    public NodeState createNew(NodeId id) {
        return new NodeState(id, null, null, 4, false);
    }

    public PropertyState createNew(PropertyId id) {
        return new PropertyState(id, 4, false);
    }

    public boolean exists(NodeId id) throws ItemStateException {
        this.debug("exists NodeId:" + id);
        Object[] results = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Serializable o;
            try {
                o = Boolean.valueOf(this.list[i].exists(id));
            }
            catch (Exception e) {
                o = e;
            }
            results[i] = o;
        }
        Object o = this.compareResults(results);
        return (Boolean)o;
    }

    public boolean exists(PropertyId id) throws ItemStateException {
        this.debug("exists PropertyId:" + id);
        Object[] results = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Serializable o;
            try {
                o = Boolean.valueOf(this.list[i].exists(id));
            }
            catch (Exception e) {
                o = e;
            }
            results[i] = o;
        }
        Object o = this.compareResults(results);
        return (Boolean)o;
    }

    public boolean existsReferencesTo(NodeId targetId) throws ItemStateException {
        this.debug("exists NodeReferencesId:" + targetId);
        Object[] results = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Serializable o;
            try {
                o = Boolean.valueOf(this.list[i].existsReferencesTo(targetId));
            }
            catch (Exception e) {
                o = e;
            }
            results[i] = o;
        }
        Object o = this.compareResults(results);
        return (Boolean)o;
    }

    public NodeState load(NodeId id) throws ItemStateException {
        this.debug("load NodeId:" + id);
        Object[] results = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Exception o;
            try {
                o = this.list[i].load(id);
            }
            catch (Exception e) {
                o = e;
            }
            results[i] = o;
        }
        Object o = this.compareResults(results);
        return (NodeState)o;
    }

    public PropertyState load(PropertyId id) throws ItemStateException {
        this.debug("load PropertyId:" + id);
        Object[] results = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Exception o;
            try {
                o = this.list[i].load(id);
            }
            catch (Exception e) {
                o = e;
            }
            results[i] = o;
        }
        Object o = this.compareResults(results);
        return (PropertyState)o;
    }

    public NodeReferences loadReferencesTo(NodeId id) throws ItemStateException {
        this.debug("load NodeReferencesId:" + id);
        Object[] results = new Object[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Exception o;
            try {
                o = this.list[i].loadReferencesTo(id);
            }
            catch (Exception e) {
                o = e;
            }
            results[i] = o;
        }
        Object o = this.compareResults(results);
        return (NodeReferences)o;
    }

    public void store(ChangeLog changeLog) throws ItemStateException {
        NodeId id;
        this.debug("store ChangeLog:" + changeLog);
        for (ItemState state : changeLog.deletedStates()) {
            if (!state.isNode()) continue;
            this.debug("delete NodeId:" + state.getId());
        }
        for (ItemState state : changeLog.addedStates()) {
            if (!state.isNode()) continue;
            id = (NodeId)state.getId();
            this.debug("add NodeId:" + id);
        }
        for (ItemState state : changeLog.modifiedStates()) {
            if (!state.isNode()) continue;
            id = (NodeId)state.getId();
            this.debug("update NodeId:" + id);
        }
        for (NodeReferences refs : changeLog.modifiedRefs()) {
            if (refs.hasReferences()) {
                this.debug("update " + refs);
                continue;
            }
            this.debug("delete " + refs);
        }
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].store(changeLog);
        }
    }

    public String getManagerClass0() {
        return this.managerClass0;
    }

    public void setManagerClass0(String managerClass0) {
        this.managerClass0 = managerClass0;
    }

    public String getManagerClass1() {
        return this.managerClass1;
    }

    public void setManagerClass1(String managerClass1) {
        this.managerClass1 = managerClass1;
    }

    private Object compareResults(Object[] results) throws ItemStateException {
        Object gold = results[0];
        this.debug("  " + gold);
        for (int i = 1; i < this.list.length; ++i) {
            Object test = results[i];
            if (gold.getClass() != test.getClass()) {
                throw this.error("expected: " + gold + " got: " + test);
            }
            if (gold instanceof NodeState) {
                NodeState ng = (NodeState)gold;
                NodeState nt = (NodeState)test;
                if (ng.getId().equals(nt.getId())) continue;
                throw this.error("expected: " + ng + " got: " + nt);
            }
            if (gold instanceof PropertyState) {
                PropertyState pg = (PropertyState)gold;
                PropertyState pt = (PropertyState)test;
                if (pg.getId().equals(pt.getId())) continue;
                throw this.error("expected: " + pg + " got: " + pt);
            }
            if (gold instanceof NodeReferences) {
                NodeReferences rg = (NodeReferences)gold;
                NodeReferences rt = (NodeReferences)test;
                if (rg.getTargetId().equals((Object)rt.getTargetId())) continue;
                throw this.error("expected: " + rg + " got: " + rt);
            }
            if (gold instanceof Exception || gold.equals(test)) continue;
            throw this.error("expected: " + gold + " got: " + test);
        }
        if (gold instanceof ItemStateException) {
            throw (ItemStateException)((Object)gold);
        }
        if (gold instanceof RuntimeException) {
            throw (RuntimeException)gold;
        }
        return gold;
    }

    private Error error(String s) {
        log.error(this.name + ": " + s);
        return new Error(this.name + ": " + s);
    }

    private void debug(String s) {
        log.debug(this.name + ": " + s);
    }

    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
    }
}

