/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence;

import com.day.crx.persistence.jdbc.BundleDbPersistenceManager;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.hsqldb.DatabaseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativePersistenceManager
extends BundleDbPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(NativePersistenceManager.class);
    private int cacheScale = 8;
    private int cacheSizeScale = 14;
    private long writeDelay = 100L;
    private long logSize = 50L;

    public void setHsqldbWriteDelay(String delay) {
        this.writeDelay = Long.parseLong(delay);
    }

    public String getHsqldbWriteDelay() {
        return String.valueOf(this.writeDelay);
    }

    public void setHsqldbLogSize(String size) {
        this.logSize = Long.parseLong(size);
    }

    public String getHsqldbLogSize() {
        return String.valueOf(this.logSize);
    }

    public void setHsqldbCacheScale(String cacheScale) {
        this.cacheScale = Integer.parseInt(cacheScale);
        if (this.cacheScale < 8) {
            this.cacheScale = 8;
        }
        if (this.cacheScale > 18) {
            this.cacheScale = 18;
        }
    }

    public String getHsqldbCacheScale() {
        return String.valueOf(this.cacheScale);
    }

    public void setHsqldbCacheSizeScale(String cacheSizeScale) {
        this.cacheSizeScale = Integer.parseInt(cacheSizeScale);
        if (this.cacheSizeScale < 6) {
            this.cacheSizeScale = 6;
        }
        if (this.cacheSizeScale > 20) {
            this.cacheSizeScale = 20;
        }
    }

    public String getHsqldbCacheSizeScale() {
        return String.valueOf(this.cacheSizeScale);
    }

    public void init(PMContext context) throws Exception {
        if (this.getDriver() == null) {
            this.setDriver("org.hsqldb.jdbcDriver");
        }
        if (this.getUrl() == null) {
            this.setUrl("jdbc:hsqldb:file:" + context.getHomeDir().getPath() + "/db/itemState");
        }
        if (this.getUser() == null) {
            this.setUser("sa");
        }
        if (this.getPassword() == null) {
            this.setPassword("");
        }
        if (this.getSchema() == null) {
            this.setSchema("native");
        }
        if (this.getSchemaObjectPrefix() == null) {
            this.setSchemaObjectPrefix("");
        }
        this.ignore(2);
        super.init(context);
    }

    private void ignore(int v) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSchema() throws SQLException, RepositoryException {
        DatabaseMetaData metaData = this.connectionManager.getConnection().getMetaData();
        double version = Double.parseDouble(metaData.getDriverMajorVersion() + "." + metaData.getDriverMinorVersion());
        boolean millisSupported = version >= 1.8;
        Statement stmt = this.connectionManager.getConnection().createStatement();
        try {
            stmt.execute("set property \"hsqldb.cache_scale\" " + this.cacheScale);
            stmt.execute("set property \"hsqldb.cache_size_scale\" " + this.cacheSizeScale);
            if (millisSupported) {
                stmt.execute("set write_delay " + this.writeDelay + " millis");
            } else {
                stmt.execute("set write_delay " + (int)Math.ceil((double)this.writeDelay / 1000.0));
            }
            stmt.execute("set logsize " + this.logSize);
            stmt.execute("checkpoint");
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        super.checkSchema();
    }

    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        Statement stmt = this.connectionManager.getConnection().createStatement();
        stmt.execute("shutdown");
        stmt.close();
        super.close();
    }

    public static void shutdown() {
        Vector v = DatabaseManager.getDatabaseURIs();
        if (v.isEmpty()) {
            DatabaseManager.getTimer().shutDown();
        } else {
            log.warn("Refusing to shutdown database timer. the following databases are still running:");
            for (int i = 0; i < v.size(); ++i) {
                log.warn(v.get(i).toString());
            }
        }
    }
}

