/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.jndi.jcrprovider;

import com.day.crx.jndi.jcrprovider.RepositoryContext;
import com.day.crx.jndi.jcrprovider.RepositoryContextLoader;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class RepositoryContextFactory
implements InitialContextFactory {
    private static Map loaders;

    public Context getInitialContext(Hashtable environment) throws NamingException {
        String path;
        block6: {
            path = (String)environment.get("java.naming.provider.url");
            if (path != null) {
                try {
                    URI uri = new URI(path);
                    if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                        throw new NamingException("Only file-URL supported.");
                    }
                    path = uri.getPath();
                    if (path == null || path.length() == 0) {
                        throw new NamingException("Missing path in URL");
                    }
                    break block6;
                }
                catch (URISyntaxException use) {
                    throw new NamingException("URL " + path + " has illegal " + "syntax: " + use.getMessage());
                }
            }
            path = System.getProperty("user.dir");
            if (path == null || path.length() == 0) {
                throw new NamingException("Cannot get current working directory");
            }
        }
        RepositoryContextLoader loader = RepositoryContextFactory.getLoader(path);
        return new RepositoryContext(loader, environment);
    }

    private static synchronized RepositoryContextLoader getLoader(String path) throws NamingException {
        RepositoryContextLoader loader;
        File contextRoot = new File(path);
        if (loaders == null) {
            loaders = new HashMap(3, 0.75f);
            loader = null;
        } else {
            loader = (RepositoryContextLoader)loaders.get(contextRoot);
        }
        if (loader == null) {
            loader = new RepositoryContextLoader(contextRoot);
            loaders.put(contextRoot, loader);
        }
        return loader;
    }
}

