/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.jndi.jcrprovider;

import com.day.crx.jndi.jcrprovider.RepositoryContextLoader;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class RepositoryContext
implements Context {
    protected static final NameParser flatParser = new NameParser(){
        private final Properties syntax = new Properties();
        {
            this.syntax.put("jndi.syntax.direction", "flat");
            this.syntax.put("jndi.syntax.ignorecase", "false");
        }

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, this.syntax);
        }
    };
    private final RepositoryContextLoader loader;
    private final Hashtable environment;

    public RepositoryContext(RepositoryContextLoader loader, Hashtable environment) {
        this.loader = loader;
        this.environment = environment == null ? new Hashtable() : (Hashtable)environment.clone();
    }

    private RepositoryContext(RepositoryContext toClone) {
        this.loader = toClone.loader;
        this.environment = (Hashtable)toClone.environment.clone();
    }

    private Object cloneCtx() {
        return new RepositoryContext(this);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.cloneCtx();
        }
        String nm = this.getComponents(name);
        return this.loader.get(nm);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.internalBind(name, obj, false);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.internalBind(name, obj, true);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        String nm = this.getComponents(name);
        this.loader.remove(nm);
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(new CompositeName(oldname), new CompositeName(newname));
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        if (oldname.isEmpty() || newname.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        String oldnm = this.getComponents(oldname);
        String newnm = this.getComponents(newname);
        this.loader.rename(oldnm, newnm);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new AbstractListing(this.loader.getNames()){

                public Object next() throws NamingException {
                    String name = String.valueOf(super.next());
                    String className = RepositoryContext.this.loader.get(name).getClass().getName();
                    return new NameClassPair(name, className);
                }
            };
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            NamingEnumeration<NameClassPair> namingEnumeration;
            try {
                namingEnumeration = ((Context)target).list("");
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ((Context)target).close();
                throw throwable;
            }
            ((Context)target).close();
            return namingEnumeration;
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new AbstractListing(this.loader.getNames()){

                public Object next() throws NamingException {
                    String name = String.valueOf(super.next());
                    return new Binding(name, RepositoryContext.this.loader.get(name));
                }
            };
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            NamingEnumeration<Binding> namingEnumeration;
            try {
                namingEnumeration = ((Context)target).listBindings("");
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ((Context)target).close();
                throw throwable;
            }
            ((Context)target).close();
            return namingEnumeration;
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("RepositoryContext does not support subcontexts");
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            ((Context)obj).close();
        }
        return flatParser;
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return this.loader.getContextPath();
    }

    public void close() {
    }

    private void internalBind(Name name, Object obj, boolean rebind) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        String nm = this.getComponents(name);
        this.loader.put(nm, obj, rebind);
    }

    protected String getComponents(Name name) throws InvalidNameException {
        if (name instanceof CompositeName) {
            if (name.size() != 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return name.get(0);
        }
        return name.toString();
    }

    private abstract class AbstractListing
    implements NamingEnumeration {
        private Iterator source;

        protected AbstractListing(Iterator source) {
            this.source = source;
        }

        public boolean hasMore() throws NamingException {
            try {
                return this.source != null && this.source.hasNext();
            }
            catch (ConcurrentModificationException cme) {
                throw new NamingException("Data has been modified");
            }
        }

        public Object next() throws NamingException {
            if (this.source == null) {
                throw new NoSuchElementException("No more data");
            }
            try {
                return this.source.next();
            }
            catch (ConcurrentModificationException cme) {
                throw new NamingException("Data has been modified");
            }
        }

        public void close() {
            this.source = null;
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }
    }
}

