/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.io.durbo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;

public class NodeTypeSet {
    private final Set nodeTypes = new HashSet();

    public void collect(Node node, boolean includeAncestors) throws RepositoryException {
        this.collect(node);
        if (includeAncestors) {
            this.collectAncestors(node);
        }
    }

    public Iterator iterator() {
        return this.nodeTypes.iterator();
    }

    private void collect(Node node) throws RepositoryException {
        this.register(node);
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            this.collect(iter.nextNode());
        }
    }

    private void collectAncestors(Node node) throws RepositoryException {
        if (node.getDepth() > 0) {
            this.collectAncestors(node.getParent());
            this.register(node);
        }
    }

    private void register(Node node) throws RepositoryException {
        this.register(node.getPrimaryNodeType());
        NodeType[] mixins = node.getMixinNodeTypes();
        for (int i = 0; i < mixins.length; ++i) {
            this.register(mixins[i]);
        }
    }

    private void register(NodeType nodeType) {
        if (nodeType != null && !this.nodeTypes.contains(nodeType.getName())) {
            this.nodeTypes.add(nodeType.getName());
            NodeType[] superTypes = nodeType.getSupertypes();
            for (int i = 0; i < superTypes.length; ++i) {
                this.nodeTypes.add(superTypes[i].getName());
            }
            NodeDefinition[] nodeDefs = nodeType.getChildNodeDefinitions();
            for (int i = 0; i < nodeDefs.length; ++i) {
                this.register(nodeDefs[i].getDefaultPrimaryType());
                NodeType[] reqs = nodeDefs[i].getRequiredPrimaryTypes();
                for (int j = 0; j < reqs.length; ++j) {
                    this.register(reqs[j]);
                }
            }
        }
    }
}

