/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.io.durbo;

import com.day.durbo.DurboNamespaceResolver;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;

public class NSResolverAdapter
implements NamespaceResolver {
    private final DurboNamespaceResolver base;
    private final NamespaceRegistry nsReg;

    public NSResolverAdapter(DurboNamespaceResolver base) {
        this.base = base;
        this.nsReg = null;
    }

    public NSResolverAdapter(DurboNamespaceResolver base, NamespaceRegistry nsReg) {
        this.base = base;
        this.nsReg = nsReg;
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = this.base.getURI(prefix);
        try {
            if (this.nsReg != null) {
                try {
                    this.nsReg.getPrefix(uri);
                }
                catch (NamespaceException e) {
                    this.nsReg.registerNamespace(prefix, uri);
                }
            }
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
        return uri;
    }

    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.base.getPrefix(uri);
        try {
            if (this.nsReg != null) {
                try {
                    this.nsReg.getPrefix(uri);
                }
                catch (NamespaceException e) {
                    this.nsReg.registerNamespace(prefix, uri);
                }
            }
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
        return prefix;
    }
}

