/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.version;

import com.day.crx.io.durbo.DurboExport;
import com.day.crx.io.durbo.NSResolverAdapter;
import com.day.durbo.DurboInput;
import com.day.durbo.DurboNamespaceResolver;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.NodeTypeInstanceHandler;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionImporter {
    private static final Logger log = LoggerFactory.getLogger(DurboInput.class);
    public static final double VERSION_1_0 = 1.0;
    public static final double VERSION_1_1 = 1.1;
    public static final double VERSION_REQUIRED = 1.0;
    private final NodeTypeRegistry ntReg;
    private final UpdatableItemStateManager stateMgr;
    private NamePathResolver resolver;
    private NodeState historyRoot;
    private DurboInput din;
    private final NamespaceRegistry nsReg;
    private Properties properties = new Properties();
    private int uuidBehavior = 1;
    private double version;
    private final ValueFactory valueFactory;
    private final SessionImpl session;

    public VersionImporter(SessionImpl session, UpdatableItemStateManager stateMgr, NodeTypeRegistry ntReg, NamespaceRegistry nsReg, ValueFactory valueFactory) {
        this.ntReg = ntReg;
        this.nsReg = nsReg;
        this.stateMgr = stateMgr;
        this.valueFactory = valueFactory;
        this.session = session;
    }

    public boolean load(NodeState historyRoot, InputStream in) throws IOException, RepositoryException {
        this.historyRoot = historyRoot;
        if (this.load(historyRoot, new DurboInput(in))) {
            in.close();
            return true;
        }
        return false;
    }

    public boolean load(NodeState historyRoot, DurboInput din) throws IOException, RepositoryException {
        if (din.getContentType().equals("crx")) {
            this.din = din;
            this.resolver = new DefaultNamePathResolver((NamespaceResolver)new NSResolverAdapter((DurboNamespaceResolver)din, this.nsReg));
            this.properties.clear();
            try {
                this.stateMgr.edit();
                this.importCRXPackage("/jcr:system/jcr:versionStorage", historyRoot);
                this.stateMgr.update();
            }
            catch (ItemStateException e) {
                log.error("Unable to import.", (Throwable)e);
                return false;
            }
            catch (RepositoryException e) {
                this.stateMgr.cancel();
                log.error("Unable to import.", (Throwable)e);
                throw e;
            }
            return true;
        }
        return false;
    }

    private Name resolveName(DurboInput.Element elem) throws RepositoryException {
        if (elem == null || elem.name() == null || elem.name().equals("")) {
            return null;
        }
        return this.resolver.getQName(elem.name());
    }

    private boolean importCRXPackage(String parentPath, NodeState parentNode) throws IOException, RepositoryException {
        DurboInput.Element elem = this.din.read();
        while (elem != null && !elem.isNodeEnd()) {
            if (elem.name().equals("Properties")) {
                this.readProperties();
                String versionStr = this.properties.getProperty("Version");
                try {
                    this.version = versionStr == null ? 0.0 : Double.valueOf(versionStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (this.version < 1.0) {
                    throw new IOException("Invalid version: " + this.version + ". At least " + 1.0 + " is needed.");
                }
            } else if (elem.name().equals("NodeTypes")) {
                this.din.skipNode();
            } else if (elem.name().equals("Content")) {
                this.importNodes(parentPath, parentNode);
            } else {
                throw new IOException("Unkown element: " + elem.name());
            }
            elem = this.din.read();
        }
        return true;
    }

    private void readProperties() throws IOException {
        DurboInput.Element elem = this.din.read();
        while (!elem.isNodeEnd()) {
            if (!elem.isProperty()) {
                throw new IOException(elem + " not allowed here.");
            }
            this.properties.setProperty(elem.name(), elem.getString());
            elem = this.din.read();
        }
    }

    private void importNodes(String parentPath, NodeState parentNode) throws IOException, RepositoryException {
        DurboInput.Element elem = this.din.read();
        while (!elem.isNodeEnd()) {
            if (!elem.isNodeStart()) {
                throw new IOException("NodeStart expected.");
            }
            this.importNode(parentPath, parentNode, this.resolveName(elem));
            elem = this.din.read();
        }
    }

    private NodeState importNode(String parentPath, NodeState parentNode, Name nodeName) throws IOException, RepositoryException {
        NodeState node = null;
        NodeId id = null;
        Name nodeType = null;
        String path = parentPath + "/" + this.resolver.getJCRName(nodeName);
        if (parentNode == this.historyRoot && nodeName.equals(NameConstants.JCR_VERSIONSTORAGE)) {
            node = parentNode;
            path = parentPath;
            id = parentNode.getNodeId();
            nodeType = parentNode.getNodeTypeName();
        }
        log.info("Importing node {}", (Object)path);
        Value[] mixinTypes = JcrUtils.NO_VALUES;
        boolean isReferenceable = false;
        int structuralType = 110;
        DurboInput.Element elem = this.din.read();
        Name name = this.resolveName(elem);
        LinkedList<NodeState> children = new LinkedList<NodeState>();
        while (elem != null) {
            if (elem.isProperty()) {
                DurboInput.Property p = (DurboInput.Property)elem;
                if (name.equals(NameConstants.JCR_PRIMARYTYPE)) {
                    nodeType = this.resolver.getQName(p.getValues()[0].getString());
                } else if (name.equals(NameConstants.JCR_MIXINTYPES)) {
                    mixinTypes = p.getJcrValues(this.valueFactory);
                } else if (name.equals(NameConstants.JCR_UUID)) {
                    id = new NodeId(p.getValues()[0].getString());
                    isReferenceable = true;
                } else if (name.equals(DurboExport.INTERNAL_PROPNAME_UUID)) {
                    id = new NodeId(p.getString());
                } else if (name.equals(DurboExport.INTERNAL_PROPNAME_FLAGS)) {
                    structuralType = p.getString().charAt(0);
                } else {
                    if (node == null) {
                        if (structuralType == 110) {
                            node = this.createNode(parentNode, nodeName, nodeType, id, mixinTypes, structuralType, isReferenceable);
                        } else {
                            log.warn("non-normal node has additional properties: ", (Object)elem.name());
                        }
                    }
                    try {
                        Value[] values = p.getJcrValues(this.valueFactory);
                        InternalValue[] vals = new InternalValue[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            vals[i] = InternalValue.create((Value)values[i], (NamePathResolver)this.resolver);
                        }
                        QPropertyDefinition def = this.findApplicablePropertyDefinition(name, p.getType(), p.isMultiple(), node);
                        PropertyState ps = this.createPropertyState(node, name, p.getType(), def);
                        ps.setValues(vals);
                        this.stateMgr.store((ItemState)ps);
                    }
                    catch (RepositoryException e) {
                        log.warn("Error while adding property: {}. {}", (Object)elem.name(), (Object)e.toString());
                    }
                }
            } else if (elem.isNodeStart()) {
                if (node == null) {
                    node = this.createNode(parentNode, nodeName, nodeType, id, mixinTypes, structuralType, isReferenceable);
                }
                if (structuralType == 104) {
                    log.warn("hint node has children...ignore importing.", (Object)elem.name());
                    this.din.skipNode();
                } else {
                    NodeState child = this.importNode(path, node, name);
                    if (child != null) {
                        children.add(child);
                    }
                }
            } else {
                if (elem.isNodeEnd()) {
                    if (node == null) {
                        if (structuralType == 105) {
                            log.warn("intermediate node as leaf...ignore creation.", (Object)nodeName);
                        } else {
                            node = this.createNode(parentNode, nodeName, nodeType, id, mixinTypes, structuralType, isReferenceable);
                        }
                    }
                    if (node == null || structuralType == 110) {
                        // empty if block
                    }
                    this.stateMgr.store((ItemState)node);
                    return node;
                }
                throw new IOException("Unexpected elem type.");
            }
            elem = this.din.read();
            name = this.resolveName(elem);
        }
        throw new EOFException("Unexpected end of input");
    }

    private NodeState createNode(NodeState parentNode, Name nodeName, Name nodeType, NodeId id, Value[] mixinTypes, int type, boolean isReferenceable) throws RepositoryException {
        if (id != null && this.stateMgr.hasItemState((ItemId)id)) {
            try {
                return (NodeState)this.stateMgr.getItemState((ItemId)id);
            }
            catch (ItemStateException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (nodeType == null) {
            throw new RepositoryException("jcr:primaryType expected.");
        }
        Name[] mixinNames = new Name[mixinTypes.length];
        for (int i = 0; i < mixinTypes.length; ++i) {
            mixinNames[i] = this.resolver.getQName(mixinTypes[i].getString());
        }
        QNodeDefinition def = this.findApplicableNodeDefinition(nodeName, nodeType, parentNode);
        return this.createNodeState(parentNode, nodeName, nodeType, mixinNames, id, def);
    }

    public NodeState createNodeState(NodeState parent, Name nodeName, Name nodeTypeName, Name[] mixinNames, NodeId id, QNodeDefinition def) throws ItemExistsException, ConstraintViolationException, RepositoryException, IllegalStateException {
        if (parent.hasPropertyName(nodeName)) {
            String msg = "there's already a property with name " + nodeName;
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!def.allowsSameNameSiblings() && parent.hasChildNodeEntry(nodeName)) {
            throw new ItemExistsException(parent.getChildNodeEntry(nodeName, 1).getId().toString());
        }
        if (nodeTypeName == null && (nodeTypeName = def.getDefaultPrimaryType()) == null) {
            String msg = "an applicable node type could not be determined for " + nodeName;
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        NodeState node = this.stateMgr.createNew(id, nodeTypeName, parent.getNodeId());
        if (mixinNames != null && mixinNames.length > 0) {
            node.setMixinTypeNames(new HashSet<Name>(Arrays.asList(mixinNames)));
        }
        parent.addChildNodeEntry(nodeName, node.getNodeId());
        EffectiveNodeType ent = this.getEffectiveNodeType(node);
        if (!node.getMixinTypeNames().isEmpty()) {
            QPropertyDefinition pd = ent.getApplicablePropertyDef(NameConstants.JCR_MIXINTYPES, 7, true);
            this.createPropertyState(node, pd.getName(), pd.getRequiredType(), pd);
        }
        return node;
    }

    public PropertyState createPropertyState(NodeState parent, Name propName, int type, QPropertyDefinition def) throws ItemExistsException, RepositoryException {
        PropertyState prop = this.stateMgr.createNew(propName, parent.getNodeId());
        if (def.getRequiredType() != 0) {
            prop.setType(def.getRequiredType());
        } else if (type != 0) {
            prop.setType(type);
        } else {
            prop.setType(1);
        }
        prop.setMultiValued(def.isMultiple());
        new NodeTypeInstanceHandler(this.session.getUserID()).setDefaultValues(prop, parent, def);
        parent.addPropertyName(propName);
        return prop;
    }

    public EffectiveNodeType getEffectiveNodeType(NodeState nodeState) throws RepositoryException {
        try {
            return this.ntReg.getEffectiveNodeType(nodeState.getNodeTypeName(), nodeState.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + nodeState;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    public QNodeDefinition findApplicableNodeDefinition(Name name, Name nodeTypeName, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicableChildNodeDef(name, nodeTypeName, this.ntReg);
    }

    public QPropertyDefinition findApplicablePropertyDefinition(Name name, int type, boolean multiValued, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type, multiValued);
    }

    public QPropertyDefinition findApplicablePropertyDefinition(Name name, int type, NodeState parentState) throws RepositoryException, ConstraintViolationException {
        EffectiveNodeType entParent = this.getEffectiveNodeType(parentState);
        return entParent.getApplicablePropertyDef(name, type);
    }

    public int getUuidBehavior() {
        return this.uuidBehavior;
    }

    public void setUuidBehavior(int uuidBehavior) {
        this.uuidBehavior = uuidBehavior;
    }
}

