/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.util;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.commons.JcrUtils;

public class NodeType2RepoMapping {
    private static final String NT_NODETYPE = "nt:unstructured";
    private static final String NT_CHILDNODEDEFINITION = "nt:unstructured";
    private static final String NT_PROPERTYDEFINITION = "nt:unstructured";
    private final NodeTypeManager ntReg;

    public NodeType2RepoMapping(NodeTypeManager ntReg) {
        this.ntReg = ntReg;
    }

    public NodeTypeTemplate createNodeTypeDef(Node node) throws RepositoryException {
        if (node == null) {
            throw new RepositoryException("Node of type 'nt:nodeType' expected.");
        }
        NodeTypeTemplate def = this.ntReg.createNodeTypeTemplate();
        String ntName = node.getProperty("jcr:nodeTypeName").getString();
        def.setName(ntName);
        def.setMixin(node.getProperty("jcr:isMixin").getBoolean());
        def.setOrderableChildNodes(node.getProperty("jcr:hasOrderableChildNodes").getBoolean());
        ArrayList<String> list = new ArrayList<String>();
        if (node.hasProperty("jcr:supertypes")) {
            Value[] values;
            Property supertypeProp = node.getProperty("jcr:supertypes");
            for (Value value : values = supertypeProp.getValues()) {
                String stName = value.getString();
                list.add(stName);
            }
        }
        def.setDeclaredSuperTypeNames(list.toArray(new String[list.size()]));
        NodeIterator ni = node.getNodes("jcr:childNodeDefinition");
        while (ni.hasNext()) {
            Node childNode = ni.nextNode();
            NodeDefinitionTemplate childDef = this.createChildNodeDef(childNode);
            def.getNodeDefinitionTemplates().add(childDef);
        }
        ni = node.getNodes("jcr:propertyDefinition");
        while (ni.hasNext()) {
            Node propNode = ni.nextNode();
            PropertyDefinitionTemplate propDef = this.createPropDef(propNode);
            def.getPropertyDefinitionTemplates().add(propDef);
        }
        if (node.hasProperty("jcr:primaryItemName")) {
            Value val = node.getProperty("jcr:primaryItemName").getValue();
            def.setPrimaryItemName(val.getString());
        }
        return def;
    }

    public PropertyDefinitionTemplate createPropDef(Node propertyDef) throws RepositoryException {
        if (propertyDef == null) {
            throw new RepositoryException("Node of type 'nt:propertyDef' expected.");
        }
        PropertyDefinitionTemplate def = this.ntReg.createPropertyDefinitionTemplate();
        if (propertyDef.hasProperty("jcr:name")) {
            def.setName(propertyDef.getProperty("jcr:name").getString());
        } else {
            def.setName("*");
        }
        def.setAutoCreated(propertyDef.getProperty("jcr:autoCreated").getBoolean());
        def.setMandatory(propertyDef.getProperty("jcr:mandatory").getBoolean());
        if (propertyDef.hasProperty("jcr:onParentVersion")) {
            Property onVersion = propertyDef.getProperty("jcr:onParentVersion");
            def.setOnParentVersion(OnParentVersionAction.valueFromName((String)onVersion.getString()));
        }
        def.setProtected(propertyDef.getProperty("jcr:protected").getBoolean());
        def.setMultiple(propertyDef.getProperty("jcr:multiple").getBoolean());
        int type = 0;
        if (propertyDef.hasProperty("jcr:requiredType")) {
            String typeProp = propertyDef.getProperty("jcr:requiredType").getString();
            type = JcrUtils.getPropertyType((String)typeProp);
        }
        def.setRequiredType(type);
        Property constr = propertyDef.getProperty("jcr:valueConstraints");
        Value[] vals = constr.getValues();
        String[] constraints = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            constraints[i] = vals[i].getString();
        }
        def.setValueConstraints(constraints);
        if (propertyDef.hasProperty("jcr:defaultValues")) {
            Property defValue = propertyDef.getProperty("jcr:defaultValues");
            def.setDefaultValues(defValue.getValues());
        }
        return def;
    }

    public NodeDefinitionTemplate createChildNodeDef(Node childNodeDef) throws RepositoryException {
        Property defaultPrimaryType;
        String dpt;
        if (childNodeDef == null) {
            throw new RepositoryException("Node of type 'nt:childNodeDef' expected.");
        }
        NodeDefinitionTemplate def = this.ntReg.createNodeDefinitionTemplate();
        if (childNodeDef.hasProperty("jcr:name")) {
            Value nameVal = childNodeDef.getProperty("jcr:name").getValue();
            def.setName(nameVal.getString());
        } else {
            def.setName("*");
        }
        def.setAutoCreated(childNodeDef.getProperty("jcr:autoCreated").getBoolean());
        def.setMandatory(childNodeDef.getProperty("jcr:mandatory").getBoolean());
        if (childNodeDef.hasProperty("jcr:onParentVersion")) {
            Property onVersion = childNodeDef.getProperty("jcr:onParentVersion");
            def.setOnParentVersion(OnParentVersionAction.valueFromName((String)onVersion.getString()));
        }
        def.setProtected(childNodeDef.getProperty("jcr:protected").getBoolean());
        if (childNodeDef.hasProperty("jcr:sameNameSiblings")) {
            def.setSameNameSiblings(childNodeDef.getProperty("jcr:sameNameSiblings").getBoolean());
        }
        if (childNodeDef.hasProperty("jcr:defaultPrimaryType") && !"".equals(dpt = (defaultPrimaryType = childNodeDef.getProperty("jcr:defaultPrimaryType")).getString())) {
            def.setDefaultPrimaryTypeName(dpt);
        }
        if (childNodeDef.hasProperty("jcr:requiredPrimaryTypes")) {
            Property rptProp = childNodeDef.getProperty("jcr:requiredPrimaryTypes");
            Value[] values = rptProp.getValues();
            String[] requiredPrimaryTypes = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                requiredPrimaryTypes[i] = values[i].getString();
            }
            def.setRequiredPrimaryTypeNames(requiredPrimaryTypes);
        }
        return def;
    }

    public static Node mapNodeType(Node parentNode, NodeType nt) throws RepositoryException {
        return NodeType2RepoMapping.mapNodeType(parentNode, nt, nt.getName());
    }

    public static Node mapNodeType(Node parentNode, NodeTypeDefinition ntd) throws RepositoryException {
        return NodeType2RepoMapping.mapNodeType(parentNode, ntd, ntd.getName());
    }

    public static Node mapNodeType(Node parentNode, NodeTypeDefinition ntd, String nodeName) throws RepositoryException {
        NodeDefinition[] cdefs;
        PropertyDefinition[] pdefs;
        if (parentNode.hasNode(nodeName)) {
            return parentNode.getNode(nodeName);
        }
        Node node = parentNode.addNode(nodeName, "nt:unstructured");
        node.setProperty("jcr:nodeTypeName", ntd.getName());
        node.setProperty("jcr:supertypes", ntd.getDeclaredSupertypeNames());
        node.setProperty("jcr:isMixin", ntd.isMixin());
        node.setProperty("jcr:hasOrderableChildNodes", ntd.hasOrderableChildNodes());
        if (ntd.getPrimaryItemName() != null) {
            node.setProperty("jcr:primaryItemName", ntd.getPrimaryItemName());
        }
        if ((pdefs = ntd.getDeclaredPropertyDefinitions()) != null) {
            for (PropertyDefinition pdef : pdefs) {
                NodeType2RepoMapping.mapPropertyDef(node, pdef);
            }
        }
        if ((cdefs = ntd.getDeclaredChildNodeDefinitions()) != null) {
            for (NodeDefinition cdef : cdefs) {
                NodeType2RepoMapping.mapNodeDef(node, cdef);
            }
        }
        return node;
    }

    public static Node mapNodeType(Node parentNode, NodeType nt, String nodeName) throws RepositoryException {
        NodeDefinition[] cdefs;
        PropertyDefinition[] pdefs;
        if (parentNode.hasNode(nodeName)) {
            return parentNode.getNode(nodeName);
        }
        Node node = parentNode.addNode(nodeName, "nt:unstructured");
        node.setProperty("jcr:nodeTypeName", nt.getName());
        if (nt.getDeclaredSupertypeNames() != null) {
            node.setProperty("jcr:supertypes", nt.getDeclaredSupertypeNames());
        } else {
            node.setProperty("jcr:supertypes", new String[0]);
        }
        node.setProperty("jcr:isMixin", nt.isMixin());
        node.setProperty("jcr:hasOrderableChildNodes", nt.hasOrderableChildNodes());
        node.setProperty("jcr:primaryItemName", nt.getPrimaryItemName());
        for (PropertyDefinition pdef : pdefs = nt.getDeclaredPropertyDefinitions()) {
            NodeType2RepoMapping.mapPropertyDef(node, pdef);
        }
        for (NodeDefinition cdef : cdefs = nt.getDeclaredChildNodeDefinitions()) {
            NodeType2RepoMapping.mapNodeDef(node, cdef);
        }
        return node;
    }

    public static Node mapPropertyDef(Node ntNode, PropertyDefinition pdef) throws RepositoryException {
        Node node = ntNode.addNode("jcr:propertyDefinition", "nt:unstructured");
        if (!pdef.getName().equals("*")) {
            node.setProperty("jcr:name", pdef.getName());
        }
        node.setProperty("jcr:autoCreated", pdef.isAutoCreated());
        node.setProperty("jcr:mandatory", pdef.isMandatory());
        node.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)pdef.getOnParentVersion()));
        node.setProperty("jcr:protected", pdef.isProtected());
        node.setProperty("jcr:requiredType", PropertyType.nameFromValue((int)pdef.getRequiredType()).toUpperCase());
        node.setProperty("jcr:valueConstraints", pdef.getValueConstraints());
        node.setProperty("jcr:defaultValues", pdef.getDefaultValues());
        node.setProperty("jcr:multiple", pdef.isMultiple());
        return node;
    }

    public static Node mapNodeDef(Node ntNode, NodeDefinition ndef) throws RepositoryException {
        Node node = ntNode.addNode("jcr:childNodeDefinition", "nt:unstructured");
        if (!ndef.getName().equals("*")) {
            node.setProperty("jcr:name", ndef.getName());
        }
        node.setProperty("jcr:autoCreated", ndef.isAutoCreated());
        node.setProperty("jcr:mandatory", ndef.isMandatory());
        node.setProperty("jcr:onParentVersion", OnParentVersionAction.nameFromValue((int)ndef.getOnParentVersion()));
        node.setProperty("jcr:protected", ndef.isProtected());
        if (ndef.getRequiredPrimaryTypeNames() != null) {
            node.setProperty("jcr:requiredPrimaryTypes", ndef.getRequiredPrimaryTypeNames());
        } else {
            node.setProperty("jcr:requiredPrimaryTypes", new String[0]);
        }
        if (ndef.getDefaultPrimaryTypeName() != null) {
            node.setProperty("jcr:defaultPrimaryType", ndef.getDefaultPrimaryTypeName());
        }
        node.setProperty("jcr:sameNameSiblings", ndef.allowsSameNameSiblings());
        return node;
    }
}

