/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.token;

import java.security.Principal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBasedAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(TokenBasedAuthentication.class);
    public static final long TOKEN_EXPIRATION = 0x6DDD00L;
    public static final String TOKEN_ATTRIBUTE = ".token";
    private static final String TOKEN_ATTRIBUTE_EXPIRY = ".token.exp";
    private static final String TOKENS_NODE_NAME = ".tokens";
    private static final String TOKENS_NT_NAME = "nt:unstructured";
    private final String token;
    private final long tokenExpiration;
    private final Session session;
    private final Map<String, String> attributes;
    private final long expiry;

    public TokenBasedAuthentication(String token, long tokenExpiration, Session session) throws RepositoryException {
        this.session = session;
        this.tokenExpiration = tokenExpiration;
        this.token = token;
        long expTime = Long.MAX_VALUE;
        if (token != null) {
            this.attributes = new HashMap<String, String>();
            Node n = session.getNodeByIdentifier(token);
            PropertyIterator it = n.getProperties();
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String name = p.getName();
                if (!name.startsWith(TOKEN_ATTRIBUTE)) continue;
                if (TOKEN_ATTRIBUTE_EXPIRY.equals(name)) {
                    expTime = p.getLong();
                    continue;
                }
                this.attributes.put(p.getName(), p.getString());
            }
        } else {
            this.attributes = Collections.emptyMap();
        }
        this.expiry = expTime;
    }

    public boolean canHandle(Credentials credentials) {
        return this.token != null && TokenBasedAuthentication.isTokenBasedLogin(credentials);
    }

    public boolean authenticate(Credentials credentials) throws RepositoryException {
        if (!(credentials instanceof SimpleCredentials)) {
            throw new RepositoryException("SimpleCredentials expected. Cannot handle " + credentials.getClass().getName());
        }
        SimpleCredentials simpleCreds = (SimpleCredentials)credentials;
        if (simpleCreds.getUserID() == null && this.token.equals(simpleCreds.getAttribute(TOKEN_ATTRIBUTE))) {
            long loginTime = new Date().getTime();
            if (this.expiry < loginTime) {
                this.removeToken();
                return false;
            }
            for (String name : this.attributes.keySet()) {
                if (this.attributes.get(name).equals(simpleCreds.getAttribute(name))) continue;
                return false;
            }
            this.resetExpiry(this.expiry, loginTime);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetExpiry(long tokenExpiry, long loginTime) {
        if (tokenExpiry - loginTime > this.tokenExpiration / 2L) return;
        long expirationTime = loginTime + this.tokenExpiration;
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(expirationTime);
        Session s = null;
        try {
            try {
                s = ((SessionImpl)this.session).createSession(this.session.getWorkspace().getName());
                Node tokenNode = s.getNodeByIdentifier(this.token);
                tokenNode.setProperty(TOKEN_ATTRIBUTE_EXPIRY, s.getValueFactory().createValue(cal));
                s.save();
            }
            catch (RepositoryException e) {
                log.warn("Internal error while resetting expiry of the login token.", (Throwable)e);
                Object var11_9 = null;
                if (s == null) return;
                s.logout();
                return;
            }
            Object var11_8 = null;
            if (s == null) return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (s == null) throw throwable;
            s.logout();
            throw throwable;
        }
        s.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeToken() {
        Session s = null;
        try {
            try {
                s = ((SessionImpl)this.session).createSession(this.session.getWorkspace().getName());
                Node tokenNode = s.getNodeByIdentifier(this.token);
                tokenNode.remove();
                s.save();
            }
            catch (RepositoryException e) {
                log.warn("Internal error while resetting expiry of the login token.", (Throwable)e);
                Object var4_5 = null;
                if (s == null) return;
                s.logout();
                return;
            }
            Object var4_4 = null;
            if (s == null) return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (s == null) throw throwable;
            s.logout();
            throw throwable;
        }
        s.logout();
    }

    public static boolean isTokenBasedLogin(Credentials creds) {
        if (creds != null && creds instanceof SimpleCredentials) {
            String uid = ((SimpleCredentials)creds).getUserID();
            return uid == null;
        }
        return false;
    }

    public static boolean doCreateToken(Credentials creds) {
        if (creds != null && creds instanceof SimpleCredentials) {
            Object attr = ((SimpleCredentials)creds).getAttribute(TOKEN_ATTRIBUTE);
            return attr != null && "".equals(attr.toString());
        }
        return false;
    }

    public static synchronized void createToken(User user, SimpleCredentials credentials, long tokenExpiration, Session session) throws RepositoryException {
        Node tokenNode;
        String workspaceName = session.getWorkspace().getName();
        if (user == null) {
            throw new RepositoryException("Cannot create login token: No corresponding node for 'null' user in workspace '" + workspaceName + "'.");
        }
        String userPath = null;
        Principal pr = user.getPrincipal();
        if (pr instanceof ItemBasedPrincipal) {
            userPath = ((ItemBasedPrincipal)pr).getPath();
        }
        if (userPath != null && session.nodeExists(userPath)) {
            Node userNode = session.getNode(userPath);
            Node tokenParent = userNode.hasNode(TOKENS_NODE_NAME) ? userNode.getNode(TOKENS_NODE_NAME) : userNode.addNode(TOKENS_NODE_NAME, TOKENS_NT_NAME);
            long creationTime = new Date().getTime();
            long expirationTime = creationTime + tokenExpiration;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(creationTime);
            String tokenName = Text.replace((String)ISO8601.format((Calendar)cal), (String)":", (String)".");
            tokenNode = tokenParent.addNode(tokenName);
            cal.setTimeInMillis(expirationTime);
            tokenNode.setProperty(TOKEN_ATTRIBUTE_EXPIRY, session.getValueFactory().createValue(cal));
            for (String name : credentials.getAttributeNames()) {
                if (TOKEN_ATTRIBUTE.equals(name)) continue;
                tokenNode.setProperty(name, credentials.getAttribute(name).toString());
            }
        } else {
            throw new RepositoryException("Cannot create login token: No corresponding node for User " + user.getID() + " in workspace '" + workspaceName + "'.");
        }
        session.save();
        credentials.setAttribute(TOKEN_ATTRIBUTE, (Object)tokenNode.getIdentifier());
    }
}

