/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.query.lucene;

import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OnWorkspaceInconsistency
extends org.apache.jackrabbit.core.query.OnWorkspaceInconsistency {
    private static final Logger log = LoggerFactory.getLogger(OnWorkspaceInconsistency.class);
    public static final OnWorkspaceInconsistency IGNORE = new OnWorkspaceInconsistency("ignore"){

        public void handleMissingChildNode(NoSuchItemStateException exception, QueryHandler handler, Path path, NodeState node, ChildNodeEntry child) throws RepositoryException {
            DefaultNamePathResolver resolver = new DefaultNamePathResolver((NamespaceRegistry)handler.getContext().getNamespaceRegistry());
            log.error("Node {} ({}) has missing child '{}' ({}) -> ignored.", new Object[]{resolver.getJCRPath(path), node.getNodeId(), resolver.getJCRName(child.getName()), child.getId()});
        }
    };
    public static final OnWorkspaceInconsistency FIX = new OnWorkspaceInconsistency("fix"){

        public void handleMissingChildNode(NoSuchItemStateException exception, QueryHandler handler, Path path, NodeState node, ChildNodeEntry child) throws RepositoryException, ItemStateException {
            DefaultNamePathResolver resolver = new DefaultNamePathResolver((NamespaceRegistry)handler.getContext().getNamespaceRegistry());
            String msg = "Node {} ({}) has missing child '{}' ({}) -> ";
            PersistenceManager pm = handler.getContext().getPersistenceManager();
            pm.checkConsistency(new String[]{node.getId().toString()}, false, true);
            node.getContainer().stateDiscarded((ItemState)node);
            node = pm.load(node.getNodeId());
            msg = node.hasChildNodeEntry(child.getId()) ? msg + "missing child ignored ({} did not fix this inconsistency)" : msg + "removed missing child";
            log.warn(msg, new Object[]{resolver.getJCRPath(path), node.getNodeId(), resolver.getJCRName(child.getName()), child.getId(), pm.getClass().getName()});
        }
    };

    private OnWorkspaceInconsistency(String name) {
        super(name);
    }

    static {
        INSTANCES.put(IGNORE.getName(), IGNORE);
        INSTANCES.put(FIX.getName(), FIX);
    }
}

