/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.query;

import com.day.crx.core.query.ScoreNodeIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.PathValue;
import org.apache.jackrabbit.value.StringValue;

public class RowIteratorImpl
implements RowIterator {
    private final ScoreNodeIterator nodes;
    private final Name[] properties;
    private final NamePathResolver resolver;

    RowIteratorImpl(ScoreNodeIterator nodes, Name[] properties, NamePathResolver resolver) {
        this.nodes = nodes;
        this.properties = properties;
        this.resolver = resolver;
    }

    public Row nextRow() throws NoSuchElementException {
        return new RowImpl(this.nodes.getScore(), this.nodes.nextNodeImpl());
    }

    public void skip(long skipNum) throws NoSuchElementException {
        this.nodes.skip(skipNum);
    }

    public long getSize() {
        return this.nodes.getSize();
    }

    public long getPosition() {
        return this.nodes.getPosition();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        return this.nodes.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.nextRow();
    }

    class RowImpl
    implements Row {
        private final float score;
        private final NodeImpl node;
        private Value[] values;
        private Set propertySet;

        RowImpl(float score, NodeImpl node) {
            this.score = score;
            this.node = node;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                Value[] tmp = new Value[RowIteratorImpl.this.properties.length];
                for (int i = 0; i < RowIteratorImpl.this.properties.length; ++i) {
                    if (this.node.hasProperty(RowIteratorImpl.this.properties[i])) {
                        PropertyImpl prop = this.node.getProperty(RowIteratorImpl.this.properties[i]);
                        if (!prop.getDefinition().isMultiple()) {
                            if (prop.getDefinition().getRequiredType() == 0) {
                                tmp[i] = new StringValue(prop.getString());
                                continue;
                            }
                            tmp[i] = prop.getValue();
                            continue;
                        }
                        tmp[i] = null;
                        continue;
                    }
                    tmp[i] = NameConstants.JCR_PATH.equals(RowIteratorImpl.this.properties[i]) ? PathValue.valueOf((String)this.node.getPath()) : (NameConstants.JCR_SCORE.equals(RowIteratorImpl.this.properties[i]) ? new LongValue((long)Math.round(this.score * 1000.0f)) : null);
                }
                this.values = tmp;
            }
            Value[] ret = new Value[this.values.length];
            System.arraycopy(this.values, 0, ret, 0, this.values.length);
            return ret;
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            Name prop;
            if (this.propertySet == null) {
                HashSet<Name> tmp = new HashSet<Name>();
                tmp.addAll(Arrays.asList(RowIteratorImpl.this.properties));
                this.propertySet = tmp;
            }
            if (!this.propertySet.contains(prop = RowIteratorImpl.this.resolver.getQName(propertyName))) {
                throw new ItemNotFoundException(propertyName);
            }
            if (this.node.hasProperty(prop)) {
                PropertyImpl p = this.node.getProperty(prop);
                if (p.getDefinition().getRequiredType() == 0) {
                    return new StringValue(p.getString());
                }
                return p.getValue();
            }
            if (NameConstants.JCR_PATH.equals(prop)) {
                return PathValue.valueOf((String)this.node.getPath());
            }
            if (NameConstants.JCR_SCORE.equals(prop)) {
                return new LongValue((long)Math.round(this.score * 1000.0f));
            }
            return null;
        }

        public Node getNode() throws RepositoryException {
            return this.node;
        }

        public String getPath() throws RepositoryException {
            return this.node.getPath();
        }

        public double getScore() throws RepositoryException {
            return this.score;
        }

        public Node getNode(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("JCR 2.0");
        }

        public String getPath(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("JCR 2.0");
        }

        public double getScore(String selectorName) throws RepositoryException {
            throw new UnsupportedRepositoryOperationException("JCR 2.0");
        }
    }
}

