/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.core.ntlm;

import com.day.crx.core.ntlm.NTLMCredentials;
import com.day.smb.ntlm.NTLM;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.authentication.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTLMCredentialsAuthentication
implements Authentication {
    private static final String NTLMHASH_PROPERTY = "ntlmhash";
    private static final Logger LOG = LoggerFactory.getLogger(NTLMCredentialsAuthentication.class);
    private final byte[] ntlmHash;

    public NTLMCredentialsAuthentication(User user) throws RepositoryException {
        byte[] ntlmHash = null;
        Value[] values = user.getProperty(NTLMHASH_PROPERTY);
        if (values != null && values.length == 1) {
            try {
                ntlmHash = NTLMCredentialsAuthentication.toByteArray(values[0].getString());
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to convert property ntlmhash into a byte array.";
                LOG.debug(msg, (Throwable)e);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        this.ntlmHash = ntlmHash;
    }

    public boolean canHandle(Credentials credentials) {
        return this.ntlmHash != null && credentials instanceof NTLMCredentials;
    }

    public boolean authenticate(Credentials credentials) throws RepositoryException {
        if (!(credentials instanceof NTLMCredentials)) {
            throw new RepositoryException("NTLMCredentials expected. Unable to handle " + credentials.getClass().getName());
        }
        NTLMCredentials c = (NTLMCredentials)credentials;
        try {
            LOG.debug("Checking NTLM credentials for {}", (Object)c.getAccountName());
            byte[] ntlmResponse = NTLM.lmResponse((byte[])this.ntlmHash, (byte[])c.getChallenge());
            return Arrays.equals(ntlmResponse, c.getNTLMResponse());
        }
        catch (Exception e) {
            String msg = "Unable to compute LM response.";
            LOG.error(msg, (Throwable)e);
            return false;
        }
    }

    public static void passwordChanged(User user, ValueFactory valueFactory, String password) {
        try {
            LOG.debug("Storing NTLM hash for user {}", (Object)user.getID());
            user.setProperty(NTLMHASH_PROPERTY, valueFactory.createValue(NTLMCredentialsAuthentication.getNTLMHash(password)));
        }
        catch (Exception e) {
            String msg = "Unable to store NTLM hash.";
            LOG.warn(msg, (Throwable)e);
        }
    }

    public static String getNTLMHash(String password) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return Text.digest((String)"ntlm", (String)password, null);
    }

    private static byte[] toByteArray(String s) throws IllegalArgumentException {
        char[] chars = s.toCharArray();
        if (chars.length % 2 != 0) {
            String msg = "Hex string must have even size.";
            throw new IllegalArgumentException(msg);
        }
        byte[] result = new byte[chars.length / 2];
        for (int i = 0; i < result.length; ++i) {
            int n = 0;
            for (int j = 0; j < 2; ++j) {
                n <<= 4;
                char ch = chars[i * 2 + j];
                if (ch >= '0' && ch <= '9') {
                    n += ch - 48;
                    continue;
                }
                if (ch >= 'A' && ch <= 'F') {
                    n += ch - 65 + 10;
                    continue;
                }
                if (ch >= 'a' && ch <= 'f') {
                    n += ch - 97 + 10;
                    continue;
                }
                String msg = "Unable to convert " + ch + " to a byte.";
                throw new IllegalArgumentException(msg);
            }
            result[i] = (byte)n;
        }
        return result;
    }
}

